#ifndef packet_h
#define packet_h

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

const int MAX_PACKET_SIZE = 4096;

class Packet
{
public:
   Packet(void);
   Packet(Packet *packet);
   Packet(char *newBuff, unsigned long buffSize);
   ~Packet(void);
   char *print(void);
   void clearPacket(void);
   void reset(void) { nextData = buff; };
   Packet& operator<<(char data);
   Packet& operator<<(unsigned int data);
   Packet& operator<<(unsigned short data);
   Packet& operator<<(unsigned long data);
   Packet& operator<<(char *data);
   Packet& operator >> (char &in);
   Packet& operator >> (unsigned short &in);
   Packet& operator >> (unsigned long &in);
   unsigned long size(void) { return(sizeVal); };
protected:
   // protected data
   char *buff;       // buffer for received data
   char *nextData;
   unsigned int maxSize;
   unsigned int sizeVal;
friend class UDPSocket;
friend class TCPSocket;
};


#endif
