#ifndef OPTIONSDLG_H
#define OPTIONSDLG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qtabdialog.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qspinbox.h>

class OptionsDlg : public QTabDialog
{
   Q_OBJECT
friend class CMainWindow;
public:
   OptionsDlg (QWidget *parent = NULL, char *name = NULL);
   enum EResultCode { Ok, Apply, Cancel };
   EResultCode ResultCode(void)  { return m_nResultCode; }

protected:
   QWidget *tab[5];
   EResultCode m_nResultCode;

   // network options tab
   QLabel *lblServers, *lblDefServerPort, *lblTcpServerPort, 
          *lblAutoAway, *lblAutoNa, *lblAutoLogon, *lblMaxUsersPerPacket;
   QComboBox *cmbServers, *cmbAutoLogon;
   QSpinBox *spnDefServerPort, *spnTcpServerPort, *spnAutoAway, *spnAutoNa,
            *spnMaxUsersPerPacket;
   QPushButton *btnAddServer;
   QCheckBox  *chkAutoLogonInvisible;
   
   // plugin tab
   QLabel *lblErrorLog, *lblUrlViewer, *lblTrans;
   QLineEdit *edtErrorLog, *edtUrlViewer;
   QComboBox *cmbTrans;
   
   // appearance tab
   QGroupBox *boxFont;
   QLabel *lblFontFamily, *lblFontSize, *lblFontCharSet;
   QLineEdit *edtFontFamily;
   QSpinBox *spnFontSize;
   QComboBox *cmbFontCharSet;
   
   QGroupBox *boxColor;
   QLabel *lblColorOnline, *lblColorAway, *lblColorOffline, *lblColorNew,
          *lblColorBackground, *lblColorGridLines;
   QLineEdit *edtColorOnline, *edtColorAway, *edtColorOffline, *edtColorNew,
             *edtColorBackground, *edtColorGridLines;
   
   QCheckBox *chkGridLines, *chkHeader, *chkAutoClose;

   // columns tab
   QLabel *lblColWidth, *lblColAlign, *lblColInfo;
   QCheckBox *chkColEnabled[4];
   QSpinBox *spnColWidth[4];
   QComboBox *cmbColAlign[4], *cmbColInfo[4];

   // sounds tab
   QLabel *lblSndType, *lblSndPlayer, *lblSndMsg, *lblSndChat,
          *lblSndUrl, *lblSndFile, *lblSndNotify;
   QComboBox *cmbSndType;
   QLineEdit *edtSndPlayer, *edtSndMsg, *edtSndChat, *edtSndUrl,
             *edtSndFile, *edtSndNotify;
   QGroupBox *boxSndEvents;
   
protected slots:
   void colEnable(bool);
   void slot_ok();
   void slot_apply();
   void slot_cancel();

signals:
  void signal_done();
};



#endif
