#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
extern int errno;

#include <stdio.h>
#include <dirent.h>
#include <qpushbutton.h>

#include "optionsdlg.h"
#include "log.h"
#include "icq-defines.h"

#include "support.h"

OptionsDlg::OptionsDlg(QWidget *parent, char *name) : QTabDialog(parent, name)
{
   resize(450, 300);
   
   // get rid of the stupid OK button
   QPushButton *okButton = CHILD(this,QPushButton,"ok");
   okButton->hide();
   
   setDefaultButton("Ok");
   setApplyButton("Apply");
   setCancelButton("Cancel");
   connect (this, SIGNAL(applyButtonPressed()), this, SLOT(slot_apply()));
   connect (this, SIGNAL(defaultButtonPressed()), this, SLOT(slot_ok()));
   connect (this, SIGNAL(cancelButtonPressed()), this, SLOT(slot_cancel()));
   
   // appearance tab
   tab[0] = new QWidget(this);
   
   // fonts
   boxFont = new QGroupBox("Font", tab[0]);
   boxFont->setGeometry(220, 10, 200, 100);
   lblFontFamily = new QLabel("Family:", boxFont);
   lblFontFamily->setGeometry(10, 20, 50, 20);
   edtFontFamily = new QLineEdit(boxFont);
   edtFontFamily->setGeometry(60, 20, 130, 20);
   lblFontCharSet = new QLabel("Char Set:", boxFont);
   lblFontCharSet->setGeometry(10, 45, 50, 20);
   cmbFontCharSet = new QComboBox(boxFont);
   cmbFontCharSet->setGeometry(60, 45, 130, 20);
   cmbFontCharSet->insertItem("ISO 8859-1 (latin)");
   cmbFontCharSet->insertItem("ISO 8859-2");
   cmbFontCharSet->insertItem("ISO 8859-3");
   cmbFontCharSet->insertItem("ISO 8859-4");
   cmbFontCharSet->insertItem("ISO 8859-5 (cyrillic)");
   cmbFontCharSet->insertItem("ISO 8859-6 (arabic)");
   cmbFontCharSet->insertItem("ISO 8859-7 (greek)");
   cmbFontCharSet->insertItem("ISO 8859-8 (hebrew)");
   cmbFontCharSet->insertItem("ISO 8859-9");
   cmbFontCharSet->insertItem("KOI8-R (russian)");
   lblFontSize = new QLabel("Size:", boxFont);
   lblFontSize->setGeometry(10, 70, 50, 20);
   spnFontSize = new QSpinBox(boxFont);
   spnFontSize->setGeometry(60, 70, 40, 20);
   
   // colors
   boxColor = new QGroupBox("Colors", tab[0]);
   boxColor->setGeometry(10, 10, 200, 180);
   lblColorOnline = new QLabel("Online:", boxColor);
   lblColorOnline->setGeometry(10, 20, 70, 20);
   edtColorOnline = new QLineEdit(boxColor);
   edtColorOnline->setGeometry(80, 20, 110, 20);
   lblColorAway = new QLabel("Away:", boxColor);
   lblColorAway->setGeometry(10, 45, 70, 20);
   edtColorAway = new QLineEdit(boxColor);
   edtColorAway->setGeometry(80, 45, 110, 20);
   lblColorOffline = new QLabel("Offline:", boxColor);
   lblColorOffline->setGeometry(10, 70, 70, 20);
   edtColorOffline = new QLineEdit(boxColor);
   edtColorOffline->setGeometry(80, 70, 110, 20);
   lblColorNew = new QLabel("New:", boxColor);
   lblColorNew->setGeometry(10, 95, 70, 20);
   edtColorNew = new QLineEdit(boxColor);
   edtColorNew->setGeometry(80, 95, 110, 20);
   lblColorBackground = new QLabel("Background:", boxColor);
   lblColorBackground->setGeometry(10, 120, 70, 20);
   edtColorBackground = new QLineEdit(boxColor);
   edtColorBackground->setGeometry(80, 120, 110, 20);
   lblColorGridLines = new QLabel("Grid Lines:", boxColor);
   lblColorGridLines->setGeometry(10, 145, 70, 20);
   edtColorGridLines = new QLineEdit(boxColor);
   edtColorGridLines->setGeometry(80, 145, 110, 20);

   chkGridLines = new QCheckBox("Grid Lines", tab[0]);
   chkGridLines->setGeometry(220, 120, 200, 20);
   chkHeader = new QCheckBox("Show Column Headers", tab[0]); 
   chkHeader->setGeometry(220, 145, 200, 20);
   chkAutoClose = new QCheckBox("Auto Close Function Window", tab[0]); 
   chkAutoClose->setGeometry(220, 170, 200, 20);

   tab[1] = new QWidget(this);
   lblColInfo = new QLabel ("Info", tab[1]);
   lblColInfo->setGeometry(100, 10, 80, 20);
   lblColWidth = new QLabel ("Width", tab[1]);
   lblColWidth->setGeometry(190, 10, 80, 20);
   lblColAlign = new QLabel("Alignment", tab[1]);
   lblColAlign->setGeometry(280, 10, 80, 20);
   char label[16];
   for (unsigned short i = 0; i < 4; i++) 
   {
      sprintf(label, "Column %d", i + 1);
      chkColEnabled[i] = new QCheckBox(label, tab[1]);
      chkColEnabled[i]->setGeometry(10, 40 + i * 25, 80, 20);
      cmbColInfo[i] = new QComboBox(tab[1]);
      cmbColInfo[i]->setGeometry(100, 40 + i * 25, 80, 20);
      cmbColInfo[i]->insertItem("Alias");
      cmbColInfo[i]->insertItem("UIN");
      cmbColInfo[i]->insertItem("Name");
      cmbColInfo[i]->insertItem("EMail");
      spnColWidth[i] = new QSpinBox(tab[1]);
      spnColWidth[i]->setGeometry(190, 40 + i * 25, 80, 20);
      spnColWidth[i]->setRange(0, 2048);
      cmbColAlign[i] = new QComboBox(tab[1]);
      cmbColAlign[i]->setGeometry(280, 40 + i * 25, 80, 20);
      cmbColAlign[i]->insertItem("Left");
      cmbColAlign[i]->insertItem("Right");
      cmbColAlign[i]->insertItem("Center");
      connect(chkColEnabled[i], SIGNAL(toggled(bool)), this, SLOT(colEnable(bool)));
   }

   tab[2] = new QWidget(this);
   lblSndType = new QLabel("Sounds:", tab[2]);
   lblSndType->setGeometry(10, 10, 50, 20);
   cmbSndType = new QComboBox(tab[2]);
   cmbSndType->setGeometry(80, 10, 120, 20);
   cmbSndType->insertItem("Disabled");
   cmbSndType->insertItem("Player");
   cmbSndType->insertItem("PC Speaker");
   lblSndPlayer = new QLabel("Sound Player:", tab[2]);
   lblSndPlayer->setGeometry(220, 10, 70, 20);
   edtSndPlayer = new QLineEdit(tab[2]);
   edtSndPlayer->setGeometry(300, 10, 120, 20);
   boxSndEvents = new QGroupBox("Events", tab[2]);
   boxSndEvents->setGeometry(10, 40, 410, 150);
   lblSndMsg = new QLabel("Message:", boxSndEvents);
   lblSndMsg->setGeometry(10, 20, 80, 20);
   edtSndMsg = new QLineEdit(boxSndEvents);
   edtSndMsg->setGeometry(90, 20, 280, 20);
   lblSndUrl = new QLabel("URL:", boxSndEvents);
   lblSndUrl->setGeometry(10, 45, 80, 20);
   edtSndUrl = new QLineEdit(boxSndEvents);
   edtSndUrl->setGeometry(90, 45, 280, 20);
   lblSndChat = new QLabel("Chat Request:", boxSndEvents);
   lblSndChat->setGeometry(10, 70, 80, 20);
   edtSndChat = new QLineEdit(boxSndEvents);
   edtSndChat->setGeometry(90, 70, 280, 20);
   lblSndFile = new QLabel("File Transfer:", boxSndEvents);
   lblSndFile->setGeometry(10, 95, 80, 20);
   edtSndFile = new QLineEdit(boxSndEvents);
   edtSndFile->setGeometry(90, 95, 280, 20);
   lblSndNotify = new QLabel("Online Notify:", boxSndEvents);
   lblSndNotify->setGeometry(10, 120, 80, 20);
   edtSndNotify = new QLineEdit(boxSndEvents);
   edtSndNotify->setGeometry(90, 120, 280, 20);

   tab[3] = new QWidget(this);
   lblServers = new QLabel ("Servers: ", tab[3]);
   lblServers->setGeometry(10, 10, 70, 20);
   lblServers->setEnabled(false);
   cmbServers = new QComboBox(false, tab[3]);
   cmbServers->setGeometry(80, 10, 150, 20);
   cmbServers->setEnabled(false);
   lblDefServerPort = new QLabel("Default Server Port:", tab[3]);
   lblDefServerPort->setGeometry(10, 35, 120, 20);
   spnDefServerPort = new QSpinBox(tab[3]);
   spnDefServerPort->setGeometry(140, 35, 90, 20);
   spnDefServerPort->setRange(0, 0xFFFF);
   lblTcpServerPort = new QLabel("TCP Server Port:", tab[3]);
   lblTcpServerPort->setGeometry(10, 60, 120, 20);
   spnTcpServerPort = new QSpinBox(tab[3]);
   spnTcpServerPort->setGeometry(140, 60, 90, 20);
   spnTcpServerPort->setRange(0, 0xFFFF);
   lblMaxUsersPerPacket = new QLabel("Max Users per Packet:", tab[3]);
   lblMaxUsersPerPacket->setGeometry(10, 85, 150, 20);
   spnMaxUsersPerPacket = new QSpinBox(tab[3]);
   spnMaxUsersPerPacket->setGeometry(170, 85, 60, 20);
   spnMaxUsersPerPacket->setRange(10, 125);
   lblAutoLogon = new QLabel("Auto Logon:", tab[3]);
   lblAutoLogon->setGeometry(160, 110, 80, 20);
   cmbAutoLogon = new QComboBox(tab[3]);
   cmbAutoLogon->setGeometry(240, 110, 120, 20);
   cmbAutoLogon->insertItem("Offline");
   cmbAutoLogon->insertItem("Online");
   cmbAutoLogon->insertItem("Away");
   cmbAutoLogon->insertItem("Not Available");
   cmbAutoLogon->insertItem("Occupied");
   cmbAutoLogon->insertItem("Do Not Disturb");
   cmbAutoLogon->insertItem("Free for Chat");
   chkAutoLogonInvisible = new QCheckBox("Invisible", tab[3]);
   chkAutoLogonInvisible->setGeometry(240, 135, 100, 20);
   lblAutoAway = new QLabel("Auto Away:", tab[3]);
   lblAutoAway->setGeometry(10, 110, 70, 20);
   spnAutoAway = new QSpinBox(tab[3]);
   spnAutoAway->setGeometry(90, 110, 50, 20);
   lblAutoNa = new QLabel("Auto N/A:", tab[3]);
   lblAutoNa->setGeometry(10, 135, 70, 20);
   spnAutoNa = new QSpinBox(tab[3]);
   spnAutoNa->setGeometry(90, 135, 50, 20);

   tab[4] = new QWidget(this);
   lblErrorLog = new QLabel("Error Log:", tab[4]);
   lblErrorLog->setGeometry(10, 35, 80, 20);
   lblErrorLog->setEnabled(false);
   edtErrorLog = new QLineEdit(tab[4]);
   edtErrorLog->setGeometry(100, 35, 200, 20);
   edtErrorLog->setEnabled(false);
   lblUrlViewer = new QLabel("Url Viewer:", tab[4]);
   lblUrlViewer->setGeometry(10, 10, 80, 20);
   edtUrlViewer = new QLineEdit(tab[4]);
   edtUrlViewer->setGeometry(100, 10, 200, 20);
   lblTrans = new QLabel("Translation:", tab[4]);
   lblTrans->setGeometry(10, 60, 80, 20);
   cmbTrans = new QComboBox(false, tab[4]);
   cmbTrans->setGeometry(100, 60, 200, 20);
   char szTransFilesDir[MAX_FILENAME_LEN];
   struct dirent **namelist;
   sprintf(szTransFilesDir, "%s%s", BASE_DIR, TRANSLATION_DIR);
   int n = scandir(szTransFilesDir, &namelist, NULL, alphasort);
   if (n < 0)
   {
     gLog.Error("%sError reading translation directory %s:\n%s%s.\n", 
                L_ERRORxSTR, szTransFilesDir, L_BLANKxSTR, strerror(errno));
     cmbTrans->insertItem("ERROR");
     cmbTrans->setEnabled(false);
   }
   else
   {
     cmbTrans->insertItem("none");
     for (unsigned short i = 0; i < n; i++)
     {
       if (namelist[i]->d_name[0] != '.')
         cmbTrans->insertItem(namelist[i]->d_name);
       free (namelist[i]);
     }
     free (namelist);
   }   

   addTab(tab[0], "Appearance");
   addTab(tab[1], "Columns");
   addTab(tab[2], "Sound");
   addTab(tab[3], "Network");
   addTab(tab[4], "Plug-In");

}

void OptionsDlg::slot_ok()
{
  m_nResultCode = Ok;
  emit signal_done();
}

void OptionsDlg::slot_apply()
{
  m_nResultCode = Apply;
  emit signal_done();
}

void OptionsDlg::slot_cancel()
{
  m_nResultCode = Cancel;
  emit signal_done();
}



void OptionsDlg::colEnable(bool isOn)
{
   unsigned short i = 0;
   while (i < 4 && chkColEnabled[i]->isChecked()) i++;
   
   // the box is checked and now i points to the first unchecked box
   if (isOn) 
   {
      // i is the next column, i - 1 is the clicked on column
      if (i > 1) chkColEnabled[i - 2]->setEnabled(false);
      if (i < 4) chkColEnabled[i]->setEnabled(true);
      if (i > 0) 
      {
         cmbColInfo[i - 1]->setEnabled(true);
         spnColWidth[i - 1]->setEnabled(true);
         cmbColAlign[i - 1]->setEnabled(true);
      }
   }
   else
   {
      // i is clicked on column which is now unchecked
      if (i < 3) chkColEnabled[i + 1]->setEnabled(false);
      if (i > 0) chkColEnabled[i - 1]->setEnabled(true);
      if (i < 4) 
      {
         cmbColInfo[i]->setEnabled(false);
         spnColWidth[i]->setEnabled(false);
         cmbColAlign[i]->setEnabled(false);
      }
   } 
}
