#ifndef LicqGUI_included
#define LicqGUI_included

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

//#include <qapp.h>
#include <qwidget.h>
#include <qcombo.h>
#include <qmenubar.h>
#include <qpopmenu.h>
#include <qlistbox.h>
#include <qgrpbox.h>
#include <qtimer.h>
#include <qimage.h>
#include <qbitmap.h>

#include "icq-defines.h"
#include "icq.h"
#include "icqfunctions.h"
#include "userbox.h"
#include "awaymsgdlg.h"
#include "outputwin.h"
#include "adduserdlg.h"
#include "authuserdlg.h"
#include "searchuserdlg.h"
#include "optionsdlg.h"
#include "skin.h"
#include "ewidgets.h"


//=====CMainWindow==============================================================
class CMainWindow: public QWidget
{
   Q_OBJECT
public:
   CMainWindow(ICQ *theServer, char *skinName, char *iconsName, 
               QWidget *parent = 0, const char *name = 0);
   ~CMainWindow(void);
protected:
   // Command Tools
   ICQ *server;
   OutputWin *netWin;
   CSkin *skin;
   
   // Dialog boxes
   AwayMsgDlg *awayMsgDlg;
   OptionsDlg *optionsDlg;
   
   // Widgets
   CUserView *userView;
   QMenuBar *menu;
   QPopupMenu *mnuSystem, 
              *mnuUser, 
              *mnuGroup,
              *mnuUserAdm, 
              *mnuStatus, 
              *mnuDebug,
              *mnuRemove,
              *mnuPlugins;
   QGroupBox *statusBar;
   CELabel *lblStatus, *lblMsg;
   CEButton *btnSystem;
   CEComboBox *cmbUserGroups;

   //QImage *imBorder;
   QPixmap *pmBorder, *pmMask;
   QBitmap bmMask;
   
   // GUI Data
   char fontFamily[32],
        colorOnline[32], colorAway[32], colorOffline[32], colorNew[32], 
        colorBackground[32], colorGridLines[32];
   unsigned short fontCharSetInt,
                  fontSize,
                  m_nAutoLogon;
   QPixmap *pmOnline, *pmOffline, *pmAway, *pmDnd, *pmOccupied, *pmNa, 
           *pmPrivate, *pmMessage;
   vector <ColInfo> colInfo;
   
   // AutoAway
   QTimer autoAwayTimer;
   unsigned short autoAwayTime, 
                  autoNATime, 
                  manualAway;
   
   // Toggles
   bool inMiniMode, 
        gridLines, 
        showHeader, 
        autoClose,
        m_bShowOffline;
   CUserGroup *m_cCurrentGroup;

   int mouseX, mouseY;

   // Functions
   void applySkin(void);
   void loadIcons(char *_sIconSet);
   void setDockIconStatus(void);
   void setDockIconMsg(bool, bool);
   void setDockIcon(const QPixmap &);
   void resizeEvent (QResizeEvent *);
   void initMenu(void);
   void callICQFunction(int fcn, bool isUser, ICQUser *user = NULL);

   virtual void mouseMoveEvent (QMouseEvent *);
   virtual void mousePressEvent (QMouseEvent *);
   virtual void mouseReleaseEvent(QMouseEvent *m);
   
protected slots:
   void removeUserFromGroup();
   void removeUserFromList();
   void addUserToGroup(int);
   void saveAllUsers();
   void updateUserWin();
   void updateStatus();
   void changeStatus(int index);
   void changeStatusManual(int index);
   void setCurrentGroup(int index);
   void callDefaultICQFunction();
   void callICQOwnerFunction();
   void callICQMsgFunction();
   void callICQUserFunction(int fcn);
   void killICQFunction(ICQUser *);
   void eventResult(ICQUser *, CUserEvent *, bool, const char *_szResponse, 
                    unsigned long port);
   void done(bool isOk, unsigned short cmd);
   void showOptions();
   void doneOptions();
   void saveOptions();
   void showAddUserDlg();
   void showAuthUserDlg();
   void showSearchUserDlg();
   void popupSystemMenu();
   void changeDebug(int);
   void slot_plugin(int);
   void miniMode();
   void ToggleShowOffline();
   void nextServer();
   void autoAway();
   void aboutBox();

signals:
   void changeDockStatus(unsigned short int);

};


#endif
