#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <iostream.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
extern int errno;

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif

#ifdef HAVE_PWD_H
#include <pwd.h>
#endif

#include <unistd.h>

#include "icq-defines.h"
#include "licq.h"
#include "countrycodes.h"

#ifdef USE_KDE
Licq::Licq(int argc, char **argv) : KApplication(argc, argv)
#else
Licq::Licq(int argc, char **argv) : QApplication(argc, argv)
#endif
{
   DEBUG_LEVEL = 0;
   quitNowVal = false;
   icq = NULL;
   licqgui = NULL;
   char skinName[32] = "";
   char iconsName[32] = "";
   
   // parse command line for arguments
   bool baseDirSet = false;   
   while(true)
   {
      int i = getopt(argc, argv, "hd:b:s:i:");
      if (i < 0) break;
      switch (i)
      {
      case 'h':  // help
	      usage();
	      quitNowVal = true; 
         return;
	   case 'b':  // base directory
	      sprintf(BASE_DIR, "%s/", optarg);
	      baseDirSet = true;
         break;
	   case 's':  // skin name
         sprintf(skinName, "%s", optarg);
         break;
	   case 'i':  // icons name
         sprintf(iconsName, "%s", optarg);
         break;
      case 'd':  // DEBUG_LEVEL
         DEBUG_LEVEL = atol(optarg);
         break;
      }
   }
   
   // Initialise the log server for standard output and dump all initial errors
   // and warnings to it regardless of DEBUG_LEVEL
   gLog.AddService(new CLogService_StdOut(DEBUG_LEVEL | L_ERROR | L_WARN));

   // if no base directory set on the command line then get it from HOME
   if (!baseDirSet)
   {
      char *home;
      if ((home = getenv("HOME")) == NULL)
      {
        gLog.Error("%sLicq: $HOME not set, unable to determine config base directory.\n", L_ERRORxSTR);
	      quitNowVal = true; 
        return;
      }
      sprintf(BASE_DIR, "%s/%s/", home, DEFAULT_HOME_DIR);
   }
   
   // check if user has conf files installed
   if (access(BASE_DIR, F_OK) < 0)  // BASE_DIR does not exist
   {
      if (!installBaseDir())
      {
         quitNowVal = true; 
         return;
      }
      cout << "Done installation, continuing load." << endl << endl;
   }
   
   setStyle(STYLE);
   InitCountryCodes();

   // create the main widgets
   gLog.Info("\n=> Setting up Licq daemon.\n");
   icq = new ICQ;
   gLog.Info("\n=> Setting up Licq GUI.\n");
   licqgui = new CMainWindow(icq, skinName, iconsName);
   gLog.Info("\n=> Initialisation complete.\n\n");
   gLog.ModifyService(S_STDOUT, DEBUG_LEVEL);

   setMainWidget(licqgui);
   licqgui->show();
   
#ifdef USE_KDE
   klicq = new KLicq(true);   
   klicq->change_dock_icon(icon());
   klicq->show();
   klicq->reset();
   connect(licqgui, SIGNAL(changeDockIcon(const QPixmap*)), kicq, SLOT(change_dock_icon(const QPixmap*)));
   connect(klicq, SIGNAL(change_status_from_dock(int)), licqgui, SLOT(changeStatusManual(int)));
   connect(klicq, SIGNAL(lowericq()), this, SLOT(hide()));
   connect(klicq, SIGNAL(raiseicq()), this, SLOT(show()));
   connect(klicq, SIGNAL(quitapp()), kapp, SLOT(quit()));
   connect(klicq, SIGNAL(doubleClicked()), licqgui, SLOT(callICQMsgFunction()));
   klicq->m_dock();    // hide or show main window!
#endif 
}


Licq::~Licq(void)
{
#ifdef USE_KDE
  KTMainWindow::deleteAll();
#else
  if (licqgui != NULL) delete licqgui;
#endif
  if (icq != NULL) delete icq;
}


void Licq::usage(void)
{
   cerr << PACKAGE << " version " << VERSION << "." << endl
        << "Usage:  Licq [-h] [-d #] [-b configdir] [-s skinname] [-i iconpack]" << endl << endl
        << " -h            this help screen" << endl
        << " -d #          set what information is logged to standard output:" << endl
        << "                   1  status information" << endl
        << "                   2  unknown packets" << endl
        << "                   4  errors" << endl
        << "                   8  warnings" << endl
        << "                  16  all packets" << endl
        << "               add values together for multiple options" << endl
        << " -b configdir  set the base directory for the config and data files" << endl
        << " -s skinname   set the skin to use (must be in {base dir}/data/skin.skinname)" << endl
        << " -i iconpack   set the icons to use (must be in {base dir}/data/icons.iconpack)" << endl
        << endl
        << "Licq defaults to reading configuration information from ~/" << DEFAULT_HOME_DIR << endl;

}


bool Licq::installBaseDir(void)
{   
   const unsigned short BUFF_SIZE = 32;

   char cmd[MAX_FILENAME_LEN + 128];
   char tmp[BUFF_SIZE];
   char szPasswd[BUFF_SIZE], *szTemp = NULL;
   int nPasswdTries;
   
   cout << PACKAGE << " version " << VERSION << " user installation."
        << endl << endl
        << "Before using " << PACKAGE << " for the first time, your configuration files must be set up." << endl << endl;

   // Enter the UIN
   cout << "Enter your Alias, UIN and password. These must be obtained by registering with" << endl 
        << "an official ICQ client - see http://www.mirabilis.com/ for details." << endl << endl;

   // Enter the Alias, password and UIN
   char alias[32];
   unsigned long uin;
   cout << "   Enter your Alias: ";
   cin.getline(alias, BUFF_SIZE, '\n');
   cout << "   Enter your UIN: ";
   cin.getline(tmp, BUFF_SIZE, '\n');
   uin = atoi(tmp);

   // Read in the password
   nPasswdTries = 3;
   while (nPasswdTries--)
   {
      szTemp = getpass("   Enter your password: ");
      strncpy(szPasswd, szTemp, BUFF_SIZE);
      szTemp = getpass("   Confirm password: ");
      if (strcmp(szTemp, szPasswd) == 0)
      {
         nPasswdTries = 0;
         break;
      }
      cout << "   They don't match." << endl << endl;
   }
   if (strcmp(szTemp, szPasswd) != 0)
   {
      cout << "   Giving up, you are a monkey." << endl;
      return (false);
   }
   
   // Create the directory
   cout << endl << "Creating " << BASE_DIR << "...";
   if (mkdir(BASE_DIR, 0700) == -1)
   {
     cout << "failed." << endl;
     cout << "Couldn't mkdir " << BASE_DIR << " - " << strerror(errno) << endl;
     return (false);
   }
   cout << "done." << endl;

   // Unpack to the directory
   cout << "Unpacking user files... ";
   sprintf(cmd, "cd %s; gunzip -dc %s/licq-base.tar.gz | tar xf -", BASE_DIR, SHARE_DIR);
   if (system(cmd) != 0)
   {
      cout << "Extract of user directory failed (" << cmd << ")." << endl 
           << "Check sub-directory existence and permissions." << endl;
      return (false);
   }
   cout << "done." << endl;   
                 
   // save them in licq.conf
   cout << "Saving info to " << BASE_DIR << CONF_DIR << "...";
   sprintf (cmd, "%s%sowner.uin", BASE_DIR, CONF_DIR);
   CIniFile licqConf(INI_FxWARN | INI_FxALLOWxCREATE);
   licqConf.LoadFile(cmd);
   licqConf.SetSection("user");
   licqConf.WriteStr("Alias", alias);
   licqConf.WriteStr("Password", szPasswd);
   licqConf.WriteNum("Uin", uin);
   licqConf.FlushFile();
   cout << "done." << endl << endl;

   return(true);
}



bool Licq::quitNow(void)
{
   return (quitNowVal);
}
