#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef USE_KDE
#include "klicq.h"
#include <qtooltip.h>
//#include "xpm/icon.xpm"

KLicq::KLicq(bool isDocked) :QLabel()
{

//Initilizing all the bit maps.... same once which are using on the licqgui

//   char filename[1024];
 
   m_isDocked = isDocked;
   OwnerIcon = NULL;
    
   setAlignment (AlignHCenter | AlignVCenter);
    
   QToolTip::add (this, "KLicq");
}

KLicq::~KLicq()
{
}

void KLicq::m_displayPixmap()
{
    if (OwnerIcon) setPixmap(*OwnerIcon);
}


void KLicq::change_dock_icon(const QPixmap *icon)
{
    OwnerIcon=icon;
    reset();
}


void KLicq::popresult(int index)
{
switch (index)
	{
	case 0:emit change_status_from_dock(0);break;
	case 1:emit change_status_from_dock(1);break;
	case 2:emit change_status_from_dock(2);break;
	case 3:emit change_status_from_dock(3);break;
	case 4:emit change_status_from_dock(4);break;
	case 5:emit change_status_from_dock(5);break;
	case 6:emit change_status_from_dock(6);break;
	case 8:m_dock();break;
	case 10:emit quitapp();break;
	}
}


void KLicq::m_popupMenu(int,int)
{
// More functions have to added here... I'll do this later. 
// but this is enough to start KDE version ;-)

        QPopupMenu *popup = new QPopupMenu(0, "popup");

        popup->insertItem("&Online");
        popup->insertItem("&Away");
        popup->insertItem("&Not Available");
        popup->insertItem("O&ccupied");
        popup->insertItem("&Do not Disturb");
        popup->insertItem("Free For &Chat");
        popup->insertItem("O&ffline");
        popup->insertSeparator();
        if (m_isDocked == false)
                popup->insertItem("&Dock");
        else
                popup->insertItem("&UnDock");
        popup->insertSeparator();
        popup->insertItem("E&xit");

        connect(popup, SIGNAL(activated(int)), this, SLOT(popresult(int)));
        popup->popup(QCursor::pos());
}


void KLicq::mousePressEvent(QMouseEvent *event)
{
        // check if this is a right click
	// Left click support to minimize and maximise licqgui
        if(event->button() == RightButton)
        {
                // popup the context menu
                m_popupMenu(event->x(), event->y());
        }
        else if (event->button() == LeftButton) {
	    m_dock();
	}
}


void KLicq::mouseDoubleClickEvent(QMouseEvent *event)
{
        // check if this is a left click
        if(event->button() == LeftButton)
        {
	    if (!m_isDocked) emit doubleClicked();
        }
}

void KLicq::reset()
{
    m_displayPixmap();
}


void KLicq::m_dock()
{
 // this is not being used... but would be used later
 if (m_isDocked) 
	{m_isDocked=false;emit raiseicq();} 
 else
 	{m_isDocked=true;emit lowericq();}  
}

#endif
