#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <qpushbt.h>
#include "gettextdlg.h"


CGetTextDlg::CGetTextDlg(char *_sTitle, char *_sDefault, char *_sResult, QWidget *parent = 0, 
                         const char *name = 0) : QDialog(parent, name)
{
   setCaption(_sTitle);
   resize(300, 100);
   mleText = new MLEditWrap(true, this);
   mleText->setGeometry(5, 5, 290, 50);
   mleText->setText(_sDefault);
   QPushButton *btnOk, *cancel;
   btnOk = new QPushButton( "Ok", this );
   btnOk->setGeometry(10, 60, 100, 30 );
   connect( btnOk, SIGNAL(clicked()), SLOT(ok()) );
   btnCancel = new QPushButton( "Cancel", this );
   btnCancel->setGeometry( 120, 60, 100, 30 );
   connect( btnCancel, SIGNAL(clicked()), SLOT(cancel()) );
   show();
}


void GetTextDlg::ok()
{
   char *s = new char[strlen((const char *)mleText->text()) + 1];
   sprintf(s, "%s", (const char *)mleText->text()); 
   emit (done(true, s));
   accept();
   delete this;
}


void GetTextDlg::cancel()
{
   char *s = new char[strlen((const char *)mleText->text()) + 1];
   sprintf(s, "%s", (const char *)mleText->text()); 
   emit (done(false, s));
   reject();
   delete this;
}
