/* libwmf ("player/defaults.h"): library for wmf conversion
   Copyright (C) 2000 - various; see CREDITS, ChangeLog, and sources

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


#ifndef WMFPLAYER_DEFAULTS_H
#define WMFPLAYER_DEFAULTS_H

static void SetDefaults (wmfAPI* API,wmfPen* pen,wmfBrush* brush,wmfFont* font)
{	wmfFontData* FD = (wmfFontData*) API->font_data;

	pen->lopnColor = wmf_rgb_black (API);
	pen->width = 1;
	pen->height = 1;
	pen->lopnStyle = PS_SOLID;

	brush->lbColor = wmf_rgb_black (API);
	brush->lbStyle = BS_NULL;
	brush->bmp.data = 0;

	font->lfHeight = 12;
	font->lfWidth = 12;
	font->lfEscapement = 0;
	font->lfOrientation = 0;
	font->lfWeight = 0;
	font->lfItalic = 0;
	font->lfUnderline = 0;
	font->lfStrikeOut = 0;
	font->lfCharSet = 0;
	font->lfOutPrecision = 0;
	font->lfClipPrecision = 0;
	font->lfQuality = 0;
	font->lfPitchAndFamily = 0;

	font->lfFaceName = wmf_strdup (API,"Times");

	FD->map (API,font);
}

#endif /* ! WMFPLAYER_DEFAULTS_H */
