/* libwmf ("ipa/svg/draw.h"): library for wmf conversion
   Copyright (C) 2000 - various; see CREDITS, ChangeLog, and sources

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


void wmf_svg_flood_interior (wmfAPI* API,wmfFlood_t* flood)
{	/* wmf_svg_t* ddata = WMF_SVG_GetData (API); */

	WMF_DEBUG (API,"~~~~~~~~wmf_[svg_]flood_interior");

	if (API->flags & WMF_OPT_IGNORE_NONFATAL)
	{	WMF_DEBUG (API,"flood_interior unsupported.");
	}
	else
	{	WMF_ERROR (API,"flood_interior unsupported.");
		API->err = wmf_E_Glitch;
	}
}

void wmf_svg_flood_exterior (wmfAPI* API,wmfFlood_t* flood)
{	/* wmf_svg_t* ddata = WMF_SVG_GetData (API); */

	WMF_DEBUG (API,"~~~~~~~~wmf_[svg_]flood_exterior");

	if (API->flags & WMF_OPT_IGNORE_NONFATAL)
	{	WMF_DEBUG (API,"flood_exterior unsupported.");
	}
	else
	{	WMF_ERROR (API,"flood_exterior unsupported.");
		API->err = wmf_E_Glitch;
	}
}

void wmf_svg_draw_pixel (wmfAPI* API,wmfDrawPixel_t* draw_pixel)
{	wmf_svg_t* ddata = WMF_SVG_GetData (API);

	wmfRGB* rgb = &(draw_pixel->color);

	svgPoint pt;

	float width;
	float height;

	FILE* out = ddata->out;

	WMF_DEBUG (API,"~~~~~~~~wmf_[svg_]draw_pixel");

	if (out == 0) return;

	pt = svg_translate (API,draw_pixel->pt);

	width  = svg_width  (API,(float) draw_pixel->pixel_width );
	height = svg_height (API,(float) draw_pixel->pixel_height);

	fputs ("<rect ",out);

	fprintf (out,"x=\"%f\" ",pt.x);
	fprintf (out,"y=\"%f\" ",pt.y);

	fprintf (out,"width=\"%f\" ",width);
	fprintf (out,"height=\"%f\" ",height);

	fprintf (out,"style=\"fill:%s; stroke:none\" ",svg_color_closest (rgb));

	fputs ("/>\n",out);
}

void wmf_svg_draw_pie (wmfAPI* API,wmfDrawArc_t* draw_arc)
{	/* wmf_svg_t* ddata = WMF_SVG_GetData (API); */

	WMF_DEBUG (API,"~~~~~~~~wmf_[svg_]draw_pie");

	svg_draw_arc (API,draw_arc,svg_arc_pie);
}

void wmf_svg_draw_chord (wmfAPI* API,wmfDrawArc_t* draw_arc)
{	/* wmf_svg_t* ddata = WMF_SVG_GetData (API); */

	WMF_DEBUG (API,"~~~~~~~~wmf_[svg_]draw_chord");

	svg_draw_arc (API,draw_arc,svg_arc_chord);
}

void wmf_svg_draw_arc (wmfAPI* API,wmfDrawArc_t* draw_arc)
{	/* wmf_svg_t* ddata = WMF_SVG_GetData (API); */

	WMF_DEBUG (API,"~~~~~~~~wmf_[svg_]draw_arc");

	svg_draw_arc (API,draw_arc,svg_arc_open);
}

void wmf_svg_draw_ellipse (wmfAPI* API,wmfDrawArc_t* draw_arc)
{	wmf_svg_t* ddata = WMF_SVG_GetData (API);

	svgPoint TL;
	svgPoint BR;

	FILE* out = ddata->out;

	WMF_DEBUG (API,"~~~~~~~~wmf_[svg_]draw_ellipse");

	if (out == 0) return;

	if (TO_FILL (draw_arc) || TO_DRAW (draw_arc))
	{	TL = svg_translate (API,draw_arc->TL);
		BR = svg_translate (API,draw_arc->BR);

		fputs ("<ellipse ",out);

		fprintf (out,"cx=\"%f\" ",(BR.x+TL.x)/2);
		fprintf (out,"cy=\"%f\" ",(BR.y+TL.y)/2);

		fprintf (out,"rx=\"%f\" ",(BR.x-TL.x)/2);
		fprintf (out,"ry=\"%f\" ",(BR.y-TL.y)/2);

		fputs ("\n\t",out);

		fputs ("style=\"",out);
		svg_style_fill (API,draw_arc->dc);
		fputs ("; ",out);
		svg_style_stroke (API,draw_arc->dc);
		fputs ("\" ",out);

		fputs ("/>\n",out);
	}
}

static void svg_draw_arc (wmfAPI* API,wmfDrawArc_t* draw_arc,svg_arc_t finish)
{	wmf_svg_t* ddata = WMF_SVG_GetData (API);

	svgPoint TL;
	svgPoint BR;

	svgPoint start;
	svgPoint end;

	FILE* out = ddata->out;

	WMF_DEBUG (API,"~~~~~~~~svg_draw_arc");

	if (out == 0) return;

	if ((draw_arc->start.x == draw_arc->end.x) || (draw_arc->start.y == draw_arc->end.y))
	{	wmf_svg_draw_ellipse (API,draw_arc);
		return;
	}

	if (TO_FILL (draw_arc) || TO_DRAW (draw_arc))
	{	TL = svg_translate (API,draw_arc->TL);
		BR = svg_translate (API,draw_arc->BR);

		start = svg_translate (API,draw_arc->start);
		end   = svg_translate (API,draw_arc->end  );

		fputs ("<path ",out);

		fputs ("d=\"",out);
		fprintf (out,"M%f,%f ",start.x,start.y); /* TODO: large angle flag in next line: */
		fprintf (out,"A%f,%f 0 0,1 %f,%f ",(BR.x-TL.x)/2,(BR.y-TL.y)/2,end.x,end.y);
		if (finish == svg_arc_pie) fprintf (out,"L%f,%f ",(BR.x+TL.x)/2,(BR.y+TL.y)/2);
		if (finish != svg_arc_open) fputs ("Z ",out);
		fputs ("\"",out);

		fputs ("\n\t",out);

		fputs ("style=\"",out);
		if (finish == svg_arc_open)
		{	fputs ("fill:none; ",out);
		}
		else
		{	svg_style_fill (API,draw_arc->dc);
			fputs ("; ",out);
		}
		svg_style_stroke (API,draw_arc->dc);
		fputs ("\" ",out);

		fputs ("/>\n",out);
	}
}

void wmf_svg_draw_line (wmfAPI* API,wmfDrawLine_t* draw_line)
{	wmf_svg_t* ddata = WMF_SVG_GetData (API);

	svgPoint from;
	svgPoint to;

	FILE* out = ddata->out;

	WMF_DEBUG (API,"~~~~~~~~wmf_[svg_]draw_line");

	if (out == 0) return;

	if (TO_DRAW (draw_line))
	{	from = svg_translate (API,draw_line->from);
		to   = svg_translate (API,draw_line->to  );

		fputs ("<line ",out);

		fprintf (out,"x1=\"%f\" ",from.x);
		fprintf (out,"y1=\"%f\" ",from.y);

		fprintf (out,"x2=\"%f\" ",to.x);
		fprintf (out,"y2=\"%f\" ",to.y);

		fputs ("\n\t",out);

		fputs ("style=\"",out);
		svg_style_stroke (API,draw_line->dc);
		fputs ("\" ",out);

		fputs ("/>\n",out);
	}
}

void wmf_svg_poly_line (wmfAPI* API,wmfPolyLine_t* poly_line)
{	wmf_svg_t* ddata = WMF_SVG_GetData (API);

	svgPoint pt;

	U16 i;

	FILE* out = ddata->out;

	WMF_DEBUG (API,"~~~~~~~~wmf_[svg_]poly_line");

	if (out == 0) return;

	if (poly_line->count <= 1) return;

	if (TO_DRAW (poly_line))
	{	fputs ("<polyline ",out);

		fputs ("points=\"",out);
		for (i = 0; i < poly_line->count; i++)
		{	if ((i & 3) == 1) fputs ("\n\t",out);

			pt = svg_translate (API,poly_line->pt[i]);

			fprintf (out,"%f,%f ",pt.x,pt.y);
		}
		fputs ("\"\n\t",out);

		fputs ("style=\"",out);
		svg_style_stroke (API,poly_line->dc);
		fputs ("\" ",out);

		fputs ("/>\n",out);
	}
}

void wmf_svg_draw_polygon (wmfAPI* API,wmfPolyLine_t* poly_line)
{	wmf_svg_t* ddata = WMF_SVG_GetData (API);

	svgPoint pt;

	U16 i;

	FILE* out = ddata->out;

	WMF_DEBUG (API,"~~~~~~~~wmf_[svg_]draw_polygon");

	if (out == 0) return;

	if (poly_line->count <= 2) return;

	if (TO_FILL (poly_line) || TO_DRAW (poly_line))
	{	fputs ("<polygon ",out);

		fputs ("points=\"",out);
		for (i = 0; i < poly_line->count; i++)
		{	if ((i & 3) == 1) fputs ("\n\t",out);

			pt = svg_translate (API,poly_line->pt[i]);

			fprintf (out,"%f,%f ",pt.x,pt.y);
		}
		fputs ("\"\n\t",out);

		fputs ("style=\"",out);
		svg_style_fill (API,poly_line->dc);
		fputs ("; ",out);
		svg_style_stroke (API,poly_line->dc);
		fputs ("\" ",out);

		fputs ("/>\n",out);
	}
}

void wmf_svg_draw_rectangle (wmfAPI* API,wmfDrawRectangle_t* draw_rect)
{	wmf_svg_t* ddata = WMF_SVG_GetData (API);

	svgPoint TL;
	svgPoint BR;

	float width;
	float height;

	FILE* out = ddata->out;

	WMF_DEBUG (API,"~~~~~~~~wmf_[svg_]draw_rectangle");

	if (out == 0) return;

	if (TO_FILL (draw_rect) || TO_DRAW (draw_rect))
	{	TL = svg_translate (API,draw_rect->TL);
		BR = svg_translate (API,draw_rect->BR);

		fputs ("<rect ",out);

		fprintf (out,"x=\"%f\" ",TL.x);
		fprintf (out,"y=\"%f\" ",TL.y);

		fprintf (out, "width=\"%f\" ",BR.x-TL.x);
		fprintf (out,"height=\"%f\" ",BR.y-TL.y);

		if ((draw_rect->width > 0) || (draw_rect->height > 0))
		{	width  = svg_width  (API,draw_rect->width ) / 2;
			height = svg_height (API,draw_rect->height) / 2;

			fprintf (out,"rx=\"%f\" ",width);
			fprintf (out,"ry=\"%f\" ",height);
		}

		fputs ("\n\t",out);

		fputs ("style=\"",out);
		svg_style_fill (API,draw_rect->dc);
		fputs ("; ",out);
		svg_style_stroke (API,draw_rect->dc);
		fputs ("\" ",out);

		fputs ("/>\n",out);
	}
}
