/* libwmf (ipa/ipa.c): library for wmf conversion
   Copyright (C) 2000 - various; see CREDITS, ChangeLog, and sources

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include <sys/stat.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

/* Define WMF_API if this is module so that ipa headers are included via "wmfdefs.h" first
 */
#define WMF_IPA 1

#include "wmfdefs.h"

#include "ipa/ipa.h"
#include "ipa/ipa/bmp.h"   /* Provides default bitmap functionality */
#include "ipa/ipa/font.h"  /* Provides default font support */
#include "ipa/ipa/color.h" /* Provides named colors */

/* Color table
 */

void wmf_ipa_color_init (wmfAPI* API)
{	wmfColorData* color;

	API->color_data = wmf_malloc (API,sizeof (wmfColorData));

	if (ERR (API))
	{	WMF_DEBUG (API,"bailing...");
		return;
	}

	color = (wmfColorData*) API->color_data;

	color->max = 32;
	color->count = 0;
	color->rgb = (wmfRGB*) wmf_malloc (API,color->max * sizeof (wmfRGB));

	if (ERR (API))
	{	WMF_DEBUG (API,"bailing...");
		return;
	}
}

void wmf_ipa_color_add (wmfAPI* API,wmfRGB* rgb)
{	wmfRGB* more = 0;

	wmfColorData* color = (wmfColorData*) API->color_data;

	unsigned long i;

	int new_color = 1;

	for (i = 0; i < color->count; i++)
	{	if ( (rgb->r == color->rgb[i].r)
		  && (rgb->g == color->rgb[i].g)
		  && (rgb->b == color->rgb[i].b))
		{	new_color = 0;
			break;
		}
	}
	if (!new_color) return;

	if (color->count == color->max)
	{	more = wmf_realloc (API,color->rgb,(color->max + 32) * sizeof (wmfRGB));

		if (ERR (API))
		{	WMF_DEBUG (API,"bailing...");
			return;
		}

		color->rgb = more;
		color->max += 32;
	}

	color->rgb[color->count] = (*rgb);
	color->count++;
}
