/* libwmf ("ipa/fig/color.h"): library for wmf conversion
   Copyright (C) 2000 - various; see CREDITS, ChangeLog, and sources

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

typedef struct color_entry
{
	int color;
	wmfRGB c;
	/* unsigned char red, green, blue; */
} Color_entry;

int num_used;

/* Should this be done dynamically? */
Color_entry color_db[512];

int fig_std_colors ()
{
	fig_put_color (0, 0.00, 0.00, 0.00);	/* Black   */
	fig_put_color (1, 0.00, 0.00, 1.00);	/* Blue    */
	fig_put_color (2, 0.00, 1.00, 0.00);	/* Green   */
	fig_put_color (3, 0.00, 1.00, 1.00);	/* Cyan    */
	fig_put_color (4, 1.00, 0.00, 0.00);	/* Red     */
	fig_put_color (5, 1.00, 0.00, 1.00);	/* Magenta */
	fig_put_color (6, 1.00, 1.00, 0.00);	/* Yellow  */
	fig_put_color (7, 1.00, 1.00, 1.00);	/* White   */


	fig_put_color (8, 0.000, 0.000, 0.560);
	fig_put_color (9, 0.000, 0.000, 0.690);
	fig_put_color (10, 0.000, 0.000, 0.820);
	fig_put_color (11, 0.530, 0.810, 1.000);
	fig_put_color (12, 0.000, 0.560, 0.000);
	fig_put_color (13, 0.000, 0.690, 0.000);
	fig_put_color (14, 0.000, 0.820, 0.000);
	fig_put_color (15, 0.000, 0.560, 0.560);
	fig_put_color (16, 0.000, 0.690, 0.690);
	fig_put_color (17, 0.000, 0.820, 0.820);
	fig_put_color (18, 0.560, 0.000, 0.000);
	fig_put_color (19, 0.690, 0.000, 0.000);
	fig_put_color (20, 0.820, 0.000, 0.000);
	fig_put_color (21, 0.560, 0.000, 0.560);
	fig_put_color (22, 0.690, 0.000, 0.690);
	fig_put_color (23, 0.820, 0.000, 0.820);
	fig_put_color (24, 0.500, 0.190, 0.000);
	fig_put_color (25, 0.630, 0.250, 0.000);
	fig_put_color (26, 0.750, 0.380, 0.000);
	fig_put_color (27, 1.000, 0.500, 0.500);
	fig_put_color (28, 1.000, 0.630, 0.630);
	fig_put_color (29, 1.000, 0.750, 0.750);
	fig_put_color (30, 1.000, 0.880, 0.880);
	fig_put_color (31, 1.000, 0.840, 0.000);

	num_used = 32;
	return (0);
}

int fig_put_color (int num, float c1, float c2, float c3)
{
	color_db[num].color = num;
	color_db[num].c.r = c1 * 0xff;
	color_db[num].c.g = c2 * 0xff;
	color_db[num].c.b = c3 * 0xff;
	return (0);
}

int fig_find_color (wmfRGB c)
{
	double dist, lastnearest, dred, dgreen, dblue;
	const double goodenough = 1;
	int nearestcolor;

	/* Check if colour already in memory database: */
	int i;
	/*
		 Exact find: 
		 for (i=0; i<num_used; i++)
		 if ((color_db[i].c.r == c.r) 
		 	&& (color_db[i].c.g == c.g) 
			&& (color_db[i].c.b == c.b))
		 return(color_db[i].color);
	 */

	/* Approximate: */
	lastnearest = 4 * 0xff;
	nearestcolor = 32;
	for (i = 0; i < num_used; i++)
		{
			dred = (color_db[i].c.r - c.r);
			dgreen = (color_db[i].c.g - c.g);
			dblue = (color_db[i].c.b - c.b);
			dist = sqrt (dred * dred + dgreen * dgreen + dblue * dblue);

			if (dist < lastnearest)
				{
					lastnearest = dist;
					nearestcolor = i;
				}
		}

	/* If close enough, return it: */
	if (lastnearest < goodenough)
		{
			return (color_db[nearestcolor].color);
		}

	/* If not, add it (exact match only): */
	color_db[num_used].color = num_used;
	color_db[num_used].c.r = c.r;
	color_db[num_used].c.g = c.g;
	color_db[num_used].c.b = c.b;


	/* .. and hand it back to caller. */
	return (color_db[num_used++].color);
}

void fig_color_to_file (FILE * fl)
{
	int i;
	char hextemp[10];

	/* Write all the collected extra colour from in-core data base
	 * to disk file.
	 */
	for (i = 32; i < num_used; i++)
		{
			/* 
			 * build formatted string in #rgb notation of colour 
			 * in memory database: 
			 */
			sprintf (hextemp, "#%02x%02x%02x", 
				color_db[i].c.r, color_db[i].c.g, color_db[i].c.b);
			/*  .. and print it out to file. */
			fprintf (fl, "0 %d %s\n", color_db[i].color, hextemp);
		}
}


void fig_handle_patterns (int area_fill, 
			int* pen_color, int* fill_color, int* thickness)
{
	/* If a pattern is specified, the given fill_color should be used to 
	 * render its lines instead of the given pen_color, and the background 
	 * should be white. Without this, Xfig would use fill_color to fill 
	 * the space between pattern lines drawn in pen_color, which is wrong.
	 */
	if (area_fill > 40)
		{
			*pen_color = *fill_color;
			*fill_color = 7;
		}
	else thickness += 1;
}

