/* libwmf ("ipa/fig.h"): library for wmf conversion
   Copyright (C) 2000 - various; see CREDITS, ChangeLog, and sources

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


#ifndef WMFIPA_FIG_H
#define WMFIPA_FIG_H

/*
 * FIG : Facility for Interactive Generation of figures
 * Copyright (c) 1985-1988 by Supoj Sutanthavibul
 * Parts Copyright (c) 1989-1998 by Brian V. Smith
 * Parts Copyright (c) 1991 by Paul King
 *
 * Any party obtaining a copy of these files is granted, free of charge, a
 * full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 * nonexclusive right and license to deal in this software and
 * documentation files (the "Software"), including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons who receive
 * copies from any such party to do so, with the only requirement being
 * that this copyright notice remain intact.
 */

/* FIG format  object codes */

#define	O_COLOR_DEF	0
#define	O_ELLIPSE	1
#define	O_POLYLINE	2
#define	O_SPLINE	3
#define	O_TEXT		4
#define	O_ARC		5
#define	O_COMPOUND	6
#define	O_END_COMPOUND	-O_COMPOUND
#define	O_ALL_OBJECT	99

/* Subtypes for O_POLYLINE */

#define	T_POLYLINE	1
#define	T_BOX		2
#define	T_POLYGON	3
#define	T_ARC_BOX	4
#define	T_PICTURE	5

/* line types */

#define	SOLID_LINE			0
#define	DASH_LINE			1
#define	DOTTED_LINE			2
#define	DASH_DOT_LINE		3
#define	DASH_2_DOTS_LINE	4
#define	DASH_3_DOTS_LINE	5

/* Join styles */

#define	JOIN_MITER	0
#define	JOIN_ROUND	1
#define	JOIN_BEVEL	2

/* cap styles */

#define	CAP_BUTT	0
#define	CAP_ROUND	1
#define	CAP_PROJECT	2

/* FIG license applies above */

static int fig_std_colors ();
static int fig_put_color (int, float, float, float);
static int fig_find_color (wmfRGB);

static void fig_color_to_file (FILE* );

static int setbrushstyle (wmfAPI*,wmfBrush*);

static int setlinestyle  (wmfPen*);
static int setjoinstyle  (wmfPen*);
static int setcapstyle   (wmfPen*);

static void wmf_draw_arc (wmfAPI*,wmfDrawArc_t*, int);

struct _PS_to_FIG
{
	char *PS_FontName;
	int  FIG_FontNumber;
};

typedef struct _PS_to_FIG PS_to_FIG;

static PS_to_FIG  PSFontNo [13] = {
	    { "Courier",              12  },
	    { "Courier-Oblique",      13  },
	    { "Courier-Bold",         14  },
	    { "Courier-BoldOblique",  15  },
	    { "Helvetica",            16  },
	    { "Helvetica-Oblique",    17  },
	    { "Helvetica-Bold",       18  },
	    { "Helvetica-BoldOblique",19  },
	    { "Times-Roman",          0   },
	    { "Times-Italic",         1   },
	    { "Times-Bold",           2   },
	    { "Times-BoldItalic",     3   },
	    { "Symbol",               32  }};

#endif /* ! WMFIPA_FIG_H */
