/* libwmf (ipa/fig.c): library for wmf conversion
   Copyright (C) 2000 - various; see CREDITS, ChangeLog, and sources

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <math.h>

/* If compiling as module, rename global functions to a standard
 */
#ifdef WMF_IPA_MODULE
#define wmf_fig_device_open    wmf_device_open
#define wmf_fig_device_close   wmf_device_close
#define wmf_fig_device_begin   wmf_device_begin
#define wmf_fig_device_end     wmf_device_end
#define wmf_fig_flood_interior wmf_flood_interior
#define wmf_fig_flood_exterior wmf_flood_exterior
#define wmf_fig_draw_pixel     wmf_draw_pixel
#define wmf_fig_draw_pie       wmf_draw_pie
#define wmf_fig_draw_chord     wmf_draw_chord
#define wmf_fig_draw_arc       wmf_draw_arc
#define wmf_fig_draw_ellipse   wmf_draw_ellipse
#define wmf_fig_draw_line      wmf_draw_line
#define wmf_fig_poly_line      wmf_poly_line
#define wmf_fig_draw_polygon   wmf_draw_polygon
#define wmf_fig_draw_rectangle wmf_draw_rectangle
#define wmf_fig_rop_draw       wmf_rop_draw
#define wmf_fig_bmp_draw       wmf_bmp_draw
#define wmf_fig_bmp_read       wmf_bmp_read
#define wmf_fig_bmp_free       wmf_bmp_free
#define wmf_fig_draw_text      wmf_draw_text
#define wmf_fig_udata_init     wmf_udata_init
#define wmf_fig_udata_copy     wmf_udata_copy
#define wmf_fig_udata_set      wmf_udata_set
#define wmf_fig_udata_free     wmf_udata_free
#define wmf_fig_region_frame   wmf_region_frame
#define wmf_fig_region_paint   wmf_region_paint
#define wmf_fig_region_clip    wmf_region_clip
#endif /* WMF_IPA_MODULE */

#include <stdio.h>
#include <math.h>

#include "wmfdefs.h"

#include "libwmf/fig.h"

#include "ipa/fig.h"
#include "ipa/fig/bmp.h"
#include "ipa/fig/color.h"
#include "ipa/fig/device.h"
#include "ipa/fig/draw.h"
#include "ipa/fig/region.h"

void wmf_fig_function (wmfAPI* API)
{	wmf_fig_t* ddata = 0;

	wmfFunctionReference* FR = (wmfFunctionReference*) API->function_reference;

/* IPA function reference links
 */
	FR->device_open    = wmf_fig_device_open;
	FR->device_close   = wmf_fig_device_close;
	FR->device_begin   = wmf_fig_device_begin;
	FR->device_end     = wmf_fig_device_end;
	FR->flood_interior = wmf_fig_flood_interior;
	FR->flood_exterior = wmf_fig_flood_exterior;
	FR->draw_pixel     = wmf_fig_draw_pixel;
	FR->draw_pie       = wmf_fig_draw_pie;
	FR->draw_chord     = wmf_fig_draw_chord;
	FR->draw_arc       = wmf_fig_draw_arc;
	FR->draw_ellipse   = wmf_fig_draw_ellipse;
	FR->draw_line      = wmf_fig_draw_line;
	FR->poly_line      = wmf_fig_poly_line;
	FR->draw_polygon   = wmf_fig_draw_polygon;
	FR->draw_rectangle = wmf_fig_draw_rectangle;
	FR->rop_draw       = wmf_fig_rop_draw;
	FR->bmp_draw       = wmf_fig_bmp_draw;
	FR->bmp_read       = wmf_fig_bmp_read;
	FR->bmp_free       = wmf_fig_bmp_free;
	FR->draw_text      = wmf_fig_draw_text;
	FR->udata_init     = wmf_fig_udata_init;
	FR->udata_copy     = wmf_fig_udata_copy;
	FR->udata_set      = wmf_fig_udata_set;
	FR->udata_free     = wmf_fig_udata_free;
	FR->region_frame   = wmf_fig_region_frame;
	FR->region_paint   = wmf_fig_region_paint;
	FR->region_clip	   = wmf_fig_region_clip;

/* Allocate device data structure
 */
	ddata = (wmf_fig_t*) wmf_malloc (API,sizeof (wmf_fig_t));

	if (ERR (API))
	{	WMF_DEBUG (API,"bailing...");
		return;
	}

	API->device_data = (void*) ddata;

/* Device data defaults
 */
	ddata->bbox.TL.x = 0;
	ddata->bbox.TL.y = 0;
	ddata->bbox.BR.x = 0;
	ddata->bbox.BR.y = 0;

	ddata->out = 0;

	ddata->offset = 0;

	ddata->Title = 0;
	ddata->Creator = 0;
	ddata->Date = 0;
	ddata->For = 0;

	ddata->fig_width = 0;
	ddata->fig_height = 0;
	
	ddata->flags = 0;
}

void wmf_fig_draw_text (wmfAPI* API,wmfDrawText_t* draw_text)
{	wmf_fig_t* ddata = WMF_FIG_GetData (API);

	FILE* out = ddata->out;

	float red;
	float green;
	float blue;
	float ratio;
	float theta;

	unsigned int i;
	unsigned int strlength;
	unsigned long height;
	unsigned int size;
	unsigned int length;
	unsigned int pen_color;
	unsigned int font;
	unsigned int sub_type;
	unsigned int font_flags;
	unsigned int pen_style;

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]draw_text");

	if (out == 0) return;

	height = draw_text->font_height;

	ratio = (float) draw_text->font_ratio;

	/* In radians: */
	theta = (float) (WMF_TEXT_ANGLE (draw_text->dc->font));

	ddata->depth -= ddata->ddec;

	/* PS points / FIG units */
	size = (height * 72 / atoi(ddata->figunit)); 

	length = 0;
	
	fputs ("# wmf_[fig_]draw_text\n",out);

	/* Text colour handling */
	red   = (float) ((int) draw_text->dc->textcolor.r) / 255;
	green = (float) ((int) draw_text->dc->textcolor.g) / 255;
	blue  = (float) ((int) draw_text->dc->textcolor.b) / 255;

	/* Here we have to either put (red,green.blue) into
	 * the FIG colour table, or find the nearest colour amongst
	 * those available. See libwmf/libxfig/color.c for how.
	 */
    pen_color = fig_find_color(draw_text->dc->textcolor);
	
	/* We should also convert 
	 * draw_text->dc->font->ps_name 
	 * to FIG number code.
	 */

	font = -1; /* Default. */

	for (i = 0; i < 13; i++)
		if (strcmp(draw_text->dc->font->ps_name, PSFontNo [i].PS_FontName) == 0)
			font = PSFontNo [i].FIG_FontNumber;

	sub_type = 0; /* Left justified for now */
	
	font_flags = 0x4; /* PostScript font for now */
	
	fprintf (out,"%d %d %d %d %d %d %d \
	 %f %d %d %d %d %d ", O_TEXT, sub_type, pen_color,\
		ddata->depth, pen_style, font, size,\
	 	theta, font_flags, height, length, \
		(int) draw_text->pt.x, (int) draw_text->pt.y);

	/* fprintf (out,"#%f 1 scale\n",ratio); */

	strlength = strlen (draw_text->str);
	for (i = 0; i < strlength; i++)
		fputc ((int) draw_text->str[i],out);
	fputs ("\\001\n",out);

	if (draw_text->dc->bgmode != TRANSPARENT)
	{	/*
		fputs ("dup stringwidth pop dup ",out);
		fprintf (out,"newpath 0 %f moveto 0 rlineto 0 %f rlineto neg 0 rlineto closepath ",
		         - 0.29 * size,1.07 * size);
		*/
			 
		/* Background colour of text */
		red   = (float) ((int) draw_text->dc->bgcolor.r) / 255;
		green = (float) ((int) draw_text->dc->bgcolor.g) / 255;
		blue  = (float) ((int) draw_text->dc->bgcolor.b) / 255;

		/* fprintf (out,"%f %f %f setrgbcolor fill ",red,green,blue); */
	}

	fputs ("# end draw_text\n",out);
}

void wmf_fig_udata_init (wmfAPI* API,wmfUserData_t* user_data)
{	/* wmf_fig_t* ddata = WMF_FIG_GetData (API); */

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]udata_init");

	
}

void wmf_fig_udata_copy (wmfAPI* API,wmfUserData_t* user_data)
{	/* wmf_fig_t* ddata = WMF_FIG_GetData (API); */

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]udata_copy");

	
}

void wmf_fig_udata_set (wmfAPI* API,wmfUserData_t* user_data)
{	/* wmf_fig_t* ddata = WMF_FIG_GetData (API); */

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]udata_set");

	
}

void wmf_fig_udata_free (wmfAPI* API,wmfUserData_t* user_data)
{	/* wmf_fig_t* ddata = WMF_FIG_GetData (API); */

	WMF_DEBUG (API,"~~~~~~~~wmf_[fig_]udata_free");

	
}



static int setlinestyle (wmfPen* pen)

{
	switch (pen->lopnStyle & PS_STYLE_MASK)
	{
	case PS_DASH: /* DASH_LINE */
		return(DASH_LINE);

	case PS_ALTERNATE:
	case PS_DOT: /* DOTTED_LINE */
		return(DOTTED_LINE);

	case PS_DASHDOT: /* DASH_DOT_LINE */
		return(DASH_DOT_LINE);
		
	case PS_DASHDOTDOT: /* DASH_2_DOTS_LINE */
		return(DASH_2_DOTS_LINE);

	case PS_INSIDEFRAME: /* There is nothing to do in this case... */
	case PS_SOLID:
	default:
		return(SOLID_LINE);
	}

}

static int setbrushstyle (wmfAPI* API,wmfBrush* brush)

{
  int fill_style=-1; /*Not filled*/
  
  /* wmfdebug(stderr,"setting fill style %d\n",brush->lbStyle); */

  if (brush->lbStyle == BS_NULL)
    return fill_style;
 
  switch(brush->lbStyle)
    {
    case BS_NULL:
      fill_style=-1;
      break;
    case BS_SOLID:
      fill_style=20;
      break;
    case BS_HATCHED:

	  switch(brush->lbHatch)
		{
		case HS_HORIZONTAL:
	  	fill_style = 49;
	  	break;
		case HS_VERTICAL:
	  	fill_style = 50;
	  	break;
		case HS_FDIAGONAL:
	  	fill_style = 44;
	  	break;
		case HS_BDIAGONAL:
	  	fill_style = 45;
	  	break;
		case HS_CROSS:
	  	fill_style = 51;
	  	break;
		case HS_DIAGCROSS:
	  	fill_style = 46;
		break;
		default:
	  	fill_style = 20;
	  	fprintf(stderr,"Unsupported Hatching: %d\n",brush->lbHatch);
	  	WMF_DEBUG (API,"Unsupported hatch style!");
		}
	  break;

	case BS_DIBPATTERN:
		WMF_DEBUG (API,"Attempt to fill with non-existent pattern!");
		break;
	default:
	fprintf(stderr,"Unsupported Brush Style: %d\n",brush->lbStyle);
	WMF_DEBUG (API,"Unsupported brush style!");
	}
	  
  return fill_style;
}


static int setcapstyle (wmfPen* pen)
{

	switch (pen->lopnStyle & PS_ENDCAP_MASK)
	{
	case PS_ENDCAP_SQUARE:
		return(CAP_PROJECT);
	break;

	case PS_ENDCAP_FLAT:
		return(CAP_PROJECT);
	break;

	case PS_ENDCAP_ROUND:
	default:
		return(CAP_ROUND);
	break;
	}
}
	
static int setjoinstyle (wmfPen* pen)
{
	switch (pen->lopnStyle & PS_JOIN_MASK)
	{
	case PS_JOIN_BEVEL:
		return(JOIN_BEVEL);
	break;

	case PS_JOIN_MITER:
		return(JOIN_MITER);
	break;

	case PS_JOIN_ROUND:
	default:
		return(JOIN_ROUND);
	break;
	}
}
