/* libwmf ("ipa/eps/device.h"): library for wmf conversion
   Copyright (C) 2000 - various; see CREDITS, ChangeLog, and sources

   The libwmf Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The libwmf Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the libwmf Library; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


/* This is called by wmf_play() the *first* time the meta file is played
 */
void wmf_eps_device_open (wmfAPI* API)
{	wmf_eps_t* ddata = WMF_EPS_GetData (API);

	WMF_DEBUG (API,"~~~~~~~~wmf_[eps_]device_open");

	if (ddata->out) ddata->offset = ftell (ddata->out);
}

/* This is called by wmf_api_destroy()
 */
void wmf_eps_device_close (wmfAPI* API)
{	wmf_eps_t* ddata = WMF_EPS_GetData (API);

	WMF_DEBUG (API,"~~~~~~~~wmf_[eps_]device_close");

	if (ddata->out) fflush (ddata->out);
}

/* This is called from the beginning of each play for initial page setup
 */
void wmf_eps_device_begin (wmfAPI* API)
{	wmf_eps_t* ddata = WMF_EPS_GetData (API);

	FILE* out = ddata->out;

	float Ox;
	float Oy;

	float xScale;
	float yScale;

	time_t t;
	
	WMF_DEBUG (API,"~~~~~~~~wmf_[eps_]device_begin");

	if (out == 0) return;

	if ((ddata->bbox.BR.x <= ddata->bbox.TL.x) || (ddata->bbox.BR.y <= ddata->bbox.TL.y))
	{	WMF_ERROR (API,"~~~~~~~~wmf_[eps_]device_begin: bounding box has null or negative size!");
		API->err = wmf_E_Glitch;
		return;
	}

	if ((ddata->eps_width == 0) || (ddata->eps_height == 0))
	{	ddata->eps_width  = (unsigned int) ceil (ddata->bbox.BR.x - ddata->bbox.TL.x);
		ddata->eps_height = (unsigned int) ceil (ddata->bbox.BR.y - ddata->bbox.TL.y);
	}

	if (out && (ddata->offset >= 0)) fseek (out,ddata->offset,SEEK_SET);

	if (ddata->flags & WMF_EPS_STYLE_PS) /* Output in full postscript style */
	{	fputs ("%!PS-Adobe-2.0\n",out);
		fputs ("%%BoundingBox: ",out);
		fprintf (out," 0 0 %u %u\n",ddata->page_width,ddata->page_height);

		if (ddata->Title)
		{	fputs ("%%Title: ",out);
			fprintf (out,"%s\n",ddata->Title);
		}
		if (ddata->Creator)
		{	fputs ("%%Creator: ",out);
			fprintf (out,"%s\n",ddata->Creator);
		}
		if (ddata->Date)
		{	fputs ("%%Date: ",out);
			fprintf (out,"%s\n",ddata->Date);
		}
		else 
		{	t = time (0);
			fputs ("%%Date: ",out);
			fprintf (out,"%s\n",ctime (&t));
		}
		if (ddata->For)
		{	fputs ("%%For: ",out);
			fprintf (out,"%s\n",ddata->For);
		}

		fputs ("%%Pages: 1\n",out);
		fputs ("%%PageOrder: Ascend\n",out);
		fputs ("%%EndComments\n",out);

		fputs ("%%BeginProlog\n",out);
		fputs (   WMF_PS_DEFS,out);
		fputs ("%%EndProlog\n",out);

		fputs ("%%BeginSetup\n",out);
		fputs ("%%EndSetup\n",out);

		fputs ("%%Page: 1 1\n",out);

		if (ddata->flags & WMF_EPS_LANDSCAPE) fputs ("%%PageOrientation: Landscape\n",out);
		else                                  fputs ("%%PageOrientation: Portrait\n" ,out);

		fputs ("%%BeginPageSetup\n",out);
		fputs (   WMF_PS_HEAD,out);

		fputs ("gsave\n",out);

		if (ddata->flags & WMF_EPS_LANDSCAPE)
		{	fprintf (out,"%u 0 translate\n",ddata->page_width);
			fputs ("90 rotate\n",out);
		}

		fputs ("%%EndPageSetup\n\n",out);

		fprintf (out,"%d %d translate\n",ddata->eps_x,ddata->eps_y);
	}
	else                   /* Output in basic encapsulated postscript style */
	{	fputs ("%!PS-Adobe-2.0 EPSF-2.0\n",out);
		fputs ("%%BoundingBox: ",out);
		fprintf (out," 0 0 %d %d\n",ddata->eps_width,ddata->eps_height);

		fputs (WMF_PS_DEFS,out);
		fputs (WMF_PS_HEAD,out);

		fprintf (out,"gsave\n");
	}

	fprintf (out,"0 %d translate\n",ddata->eps_height);

	fputs ("1 -1 scale\n",out);

	Ox = - ((float) ddata->eps_width  * ddata->bbox.TL.x) / (ddata->bbox.BR.x - ddata->bbox.TL.x);
	Oy = - ((float) ddata->eps_height * ddata->bbox.TL.y) / (ddata->bbox.BR.y - ddata->bbox.TL.y);

	fprintf (out,"%f %f translate\n",Ox,Oy);

	xScale = (float) ddata->eps_width  / (ddata->bbox.BR.x - ddata->bbox.TL.x);
	yScale = (float) ddata->eps_height / (ddata->bbox.BR.y - ddata->bbox.TL.y);

	fprintf (out,"%f %f scale\n",xScale,yScale);

	fputs ("gsave % begin clip\n",out);
}

/* This is called from the end of each play for page termination
 */
void wmf_eps_device_end (wmfAPI* API)
{	wmf_eps_t* ddata = WMF_EPS_GetData (API);

	FILE* out = ddata->out;

	WMF_DEBUG (API,"~~~~~~~~wmf_[eps_]device_end");

	if (out == 0) return;

	fputs ("grestore % end clip\n",out);

	if (ddata->flags & WMF_EPS_STYLE_PS) /* Output in full postscript style */
	{	fputs ("%%PageTrailer\n",out);

		fputs ("grestore\n",out);

		fputs (WMF_PS_TAIL,out);

		fputs ("showpage\n",out);

		fputs ("%%Trailer\n",out);
		fputs ("%%EOF\n",out);
	}
	else                   /* Output in basic encapsulated postscript style */
	{	fputs ("grestore\n",out);

		fputs (WMF_PS_TAIL,out);

		fputs ("showpage\n",out);
	}
}
