/* This file contains a standalone function to test whether a Unicode
   character is valid in universal character names in identifiers. */

/* The set taken is the one listed in C99 (ISO/IEC 9899:1999, Annex D).

       Latin:         0041-005A, 0061-007A,
                      00AA, 00BA, 00C0-00D6, 00D8-00F6, 00F8-01F5,
                      01FA-0217, 0250-02A8, 1E00-1E9B, 1EA0-1EF9,
                      207F

       Greek:         0386, 0388-038A, 038C, 038E-03A1, 03A3-03CE,
                      03D0-03D6, 03DA, 03DC, 03DE, 03E0, 03E2-03F3,
                      1F00-1F15, 1F18-1F1D, 1F20-1F45, 1F48-1F4D,
                      1F50-1F57, 1F59, 1F5B, 1F5D, 1F5F-1F7D,
                      1F80-1FB4, 1FB6-1FBC, 1FC2-1FC4, 1FC6-1FCC,
                      1FD0-1FD3, 1FD6-1FDB, 1FE0-1FEC, 1FF2-1FF4,
                      1FF6-1FFC

       Cyrillic:      0401-040C, 040E-044F, 0451-045C, 045E-0481,
                      0490-04C4, 04C7-04C8, 04CB-04CC, 04D0-04EB,
                      04EE-04F5, 04F8-04F9

       Armenian:      0531-0556, 0561-0587

       Hebrew:        05B0-05B9, 05BB-05BD, 05BF, 05C1-05C2,
                      05D0-05EA, 05F0-05F2

       Arabic:        0621-063A, 0640-0652, 0670-06B7, 06BA-06BE,
                      06C0-06CE, 06D0-06DC, 06E5-06E8, 06EA-06ED

       Devanagari:    0901-0903, 0905-0939, 093E-094D, 0950-0952,
                      0958-0963

       Bengali:       0981-0983, 0985-098C, 098F-0990, 0993-09A8,
                      09AA-09B0, 09B2, 09B6-09B9, 09BE-09C4,
                      09C7-09C8, 09CB-09CD, 09DC-09DD, 09DF-09E3,
                      09F0-09F1

       Gurmukhi:      0A02, 0A05-0A0A, 0A0F-0A10, 0A13-0A28,
                      0A2A-0A30, 0A32-0A33, 0A35-0A36, 0A38-0A39,
                      0A3E-0A42, 0A47-0A48, 0A4B-0A4D, 0A59-0A5C,
                      0A5E, 0A74

       Gujarati:      0A81-0A83, 0A85-0A8B, 0A8D, 0A8F-0A91,
                      0A93-0AA8, 0AAA-0AB0, 0AB2-0AB3, 0AB5-0AB9,
                      0ABD-0AC5, 0AC7-0AC9, 0ACB-0ACD, 0AD0, 0AE0

       Oriya:         0B01-0B03, 0B05-0B0C, 0B0F-0B10, 0B13-0B28,
                      0B2A-0B30, 0B32-0B33, 0B36-0B39, 0B3E-0B43,
                      0B47-0B48, 0B4B-0B4D, 0B5C-0B5D, 0B5F-0B61

       Tamil:         0B82-0B83, 0B85-0B8A, 0B8E-0B90, 0B92-0B95,
                      0B99-0B9A, 0B9C, 0B9E-0B9F, 0BA3-0BA4,
                      0BA8-0BAA, 0BAE-0BB5, 0BB7-0BB9, 0BBE-0BC2,
                      0BC6-0BC8, 0BCA-0BCD

       Telugu:        0C01-0C03, 0C05-0C0C, 0C0E-0C10, 0C12-0C28,
                      0C2A-0C33, 0C35-0C39, 0C3E-0C44, 0C46-0C48,
                      0C4A-0C4D, 0C60-0C61

       Kannada:       0C82-0C83, 0C85-0C8C, 0C8E-0C90, 0C92-0CA8,
                      0CAA-0CB3, 0CB5-0CB9, 0CBE-0CC4, 0CC6-0CC8,
                      0CCA-0CCD, 0CDE, 0CE0-0CE1

       Malayalam:     0D02-0D03, 0D05-0D0C, 0D0E-0D10, 0D12-0D28,
                      0D2A-0D39, 0D3E-0D43, 0D46-0D48, 0D4A-0D4D,
                      0D60-0D61

       Thai:          0E01-0E3A, 0E40-0E5B

       Lao:           0E81-0E82, 0E84, 0E87-0E88, 0E8A, 0E8D,
                      0E94-0E97, 0E99-0E9F, 0EA1-0EA3, 0EA5, 0EA7,
                      0EAA-0EAB, 0EAD-0EAE, 0EB0-0EB9, 0EBB-0EBD,
                      0EC0-0EC4, 0EC6, 0EC8-0ECD, 0EDC-0EDD

       Tibetan:       0F00, 0F18-0F19, 0F35, 0F37, 0F39, 0F3E-0F47,
                      0F49-0F69, 0F71-0F84, 0F86-0F8B, 0F90-0F95,
                      0F97, 0F99-0FAD, 0FB1-0FB7, 0FB9

       Georgian:      10A0-10C5, 10D0-10F6

       Hiragana:      3041-3093, 309B-309C

       Katakana:      30A1-30F6, 30FB-30FC

       Bopomofo:      3105-312C

       CJK Unified Ideographs: 4E00-9FA5

       Hangul:        AC00-D7A3

       Digits:        0030-0039,
                      0660-0669, 06F0-06F9, 0966-096F, 09E6-09EF,
                      0A66-0A6F, 0AE6-0AEF, 0B66-0B6F, 0BE7-0BEF,
                      0C66-0C6F, 0CE6-0CEF, 0D66-0D6F, 0E50-0E59,
                      0ED0-0ED9, 0F20-0F33

       Underscore:    005F

       Special characters: 00B5, 00B7, 02B0-02B8, 02BB, 02BD-02C1,
                      02D0-02D1, 02E0-02E4, 037A, 0559, 093D, 0B3D,
                      1FBE, 203F-2040, 2102, 2107, 210A-2113, 2115,
                      2118-211D, 2124, 2126, 2128, 212A-2131,
                      2133-2138, 2160-2182, 3005-3007, 3021-3029

*/

static const unsigned char c_ident_data[14*64] = {
  /* 0x0000-0x01ff */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x03, /* 0x0000-0x003f */
  0xfe, 0xff, 0xff, 0x87, 0xfe, 0xff, 0xff, 0x07, /* 0x0040-0x007f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xa0, 0x04, /* 0x0080-0x00bf */
  0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0x7f, 0xff, /* 0x00c0-0x00ff */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x0100-0x013f */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x0140-0x017f */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x0180-0x01bf */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xfc, /* 0x01c0-0x01ff */
  /* 0x0200-0x03ff */
  0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0200-0x023f */
  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x0240-0x027f */
  0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0xff, 0xe9, /* 0x0280-0x02bf */
  0x03, 0x00, 0x03, 0x00, 0x1f, 0x00, 0x00, 0x00, /* 0x02c0-0x02ff */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0300-0x033f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, /* 0x0340-0x037f */
  0x40, 0xd7, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, /* 0x0380-0x03bf */
  0xff, 0x7f, 0x7f, 0x54, 0xfd, 0xff, 0x0f, 0x00, /* 0x03c0-0x03ff */
  /* 0x0400-0x05ff */
  0xfe, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x0400-0x043f */
  0xff, 0xff, 0xfe, 0xdf, 0xff, 0xff, 0xff, 0xff, /* 0x0440-0x047f */
  0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x0480-0x04bf */
  0x9f, 0x19, 0xff, 0xff, 0xff, 0xcf, 0x3f, 0x03, /* 0x04c0-0x04ff */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, /* 0x0500-0x053f */
  0xff, 0xff, 0x7f, 0x02, 0xfe, 0xff, 0xff, 0xff, /* 0x0540-0x057f */
  0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xbb, /* 0x0580-0x05bf */
  0x06, 0x00, 0xff, 0xff, 0xff, 0x07, 0x07, 0x00, /* 0x05c0-0x05ff */
  /* 0x0600-0x07ff */
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x07, /* 0x0600-0x063f */
  0xff, 0xff, 0x07, 0x00, 0xff, 0x03, 0xff, 0xff, /* 0x0640-0x067f */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c, /* 0x0680-0x06bf */
  0xff, 0x7f, 0xff, 0x1f, 0xe0, 0x3d, 0xff, 0x03, /* 0x06c0-0x06ff */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0700-0x073f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0740-0x077f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0780-0x07bf */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x07c0-0x07ff */
  /* 0x0800-0x09ff */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0800-0x083f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0840-0x087f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0880-0x08bf */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x08c0-0x08ff */
  0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, /* 0x0900-0x093f */
  0xff, 0x3f, 0x07, 0xff, 0xcf, 0xff, 0x00, 0x00, /* 0x0940-0x097f */
  0xee, 0x9f, 0xf9, 0xff, 0xff, 0xfd, 0xc5, 0xc3, /* 0x0980-0x09bf */
  0x9f, 0x39, 0x00, 0xb0, 0xcf, 0xff, 0x03, 0x00, /* 0x09c0-0x09ff */
  /* 0x0a00-0x0bff */
  0xe4, 0x87, 0xf9, 0xff, 0xff, 0xfd, 0x6d, 0xc3, /* 0x0a00-0x0a3f */
  0x87, 0x39, 0x00, 0x5e, 0xc0, 0xff, 0x10, 0x00, /* 0x0a40-0x0a7f */
  0xee, 0xaf, 0xfb, 0xff, 0xff, 0xfd, 0xed, 0xe3, /* 0x0a80-0x0abf */
  0xbf, 0x3b, 0x01, 0x00, 0xc1, 0xff, 0x00, 0x00, /* 0x0ac0-0x0aff */
  0xee, 0x9f, 0xf9, 0xff, 0xff, 0xfd, 0xcd, 0xe3, /* 0x0b00-0x0b3f */
  0x8f, 0x39, 0x00, 0xb0, 0xc3, 0xff, 0x00, 0x00, /* 0x0b40-0x0b7f */
  0xec, 0xc7, 0x3d, 0xd6, 0x18, 0xc7, 0xbf, 0xc3, /* 0x0b80-0x0bbf */
  0xc7, 0x3d, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, /* 0x0bc0-0x0bff */
  /* 0x0c00-0x0dff */
  0xee, 0xdf, 0xfd, 0xff, 0xff, 0xfd, 0xef, 0xc3, /* 0x0c00-0x0c3f */
  0xdf, 0x3d, 0x00, 0x00, 0xc3, 0xff, 0x00, 0x00, /* 0x0c40-0x0c7f */
  0xec, 0xdf, 0xfd, 0xff, 0xff, 0xfd, 0xef, 0xc3, /* 0x0c80-0x0cbf */
  0xdf, 0x3d, 0x00, 0x40, 0xc3, 0xff, 0x00, 0x00, /* 0x0cc0-0x0cff */
  0xec, 0xdf, 0xfd, 0xff, 0xff, 0xfd, 0xff, 0xc3, /* 0x0d00-0x0d3f */
  0xcf, 0x3d, 0x00, 0x00, 0xc3, 0xff, 0x00, 0x00, /* 0x0d40-0x0d7f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0d80-0x0dbf */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0dc0-0x0dff */
  /* 0x0e00-0x0fff */
  0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, /* 0x0e00-0x0e3f */
  0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, /* 0x0e40-0x0e7f */
  0x96, 0x25, 0xf0, 0xfe, 0xae, 0x6c, 0xff, 0x3b, /* 0x0e80-0x0ebf */
  0x5f, 0x3f, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, /* 0x0ec0-0x0eff */
  0x01, 0x00, 0x00, 0x03, 0xff, 0xff, 0xaf, 0xc2, /* 0x0f00-0x0f3f */
  0xff, 0xfe, 0xff, 0xff, 0xff, 0x03, 0xfe, 0xff, /* 0x0f40-0x0f7f */
  0xdf, 0x0f, 0xbf, 0xfe, 0xff, 0x3f, 0xfe, 0x02, /* 0x0f80-0x0fbf */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x0fc0-0x0fff */
  /* 0x1000-0x11ff */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x1000-0x103f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x1040-0x107f */
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* 0x1080-0x10bf */
  0x3f, 0x00, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, /* 0x10c0-0x10ff */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x1100-0x113f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x1140-0x117f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x1180-0x11bf */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x11c0-0x11ff */
  /* 0x1e00-0x1fff */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x1e00-0x1e3f */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x1e40-0x1e7f */
  0xff, 0xff, 0xff, 0x0f, 0xff, 0xff, 0xff, 0xff, /* 0x1e80-0x1ebf */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, /* 0x1ec0-0x1eff */
  0xff, 0xff, 0x3f, 0x3f, 0xff, 0xff, 0xff, 0xff, /* 0x1f00-0x1f3f */
  0x3f, 0x3f, 0xff, 0xaa, 0xff, 0xff, 0xff, 0x3f, /* 0x1f40-0x1f7f */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x5f, /* 0x1f80-0x1fbf */
  0xdc, 0x1f, 0xcf, 0x0f, 0xff, 0x1f, 0xdc, 0x1f, /* 0x1fc0-0x1fff */
  /* 0x2000-0x21ff */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, /* 0x2000-0x203f */
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, /* 0x2040-0x207f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x2080-0x20bf */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x20c0-0x20ff */
  0x84, 0xfc, 0x2f, 0x3f, 0x50, 0xfd, 0xfb, 0x01, /* 0x2100-0x213f */
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, /* 0x2140-0x217f */
  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x2180-0x21bf */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x21c0-0x21ff */
  /* 0x3000-0x31ff */
  0xe0, 0x00, 0x00, 0x00, 0xfe, 0x03, 0x00, 0x00, /* 0x3000-0x303f */
  0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x3040-0x307f */
  0xff, 0xff, 0x0f, 0x18, 0xfe, 0xff, 0xff, 0xff, /* 0x3080-0x30bf */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x18, /* 0x30c0-0x30ff */
  0xe0, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, /* 0x3100-0x313f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x3140-0x317f */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x3180-0x31bf */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x31c0-0x31ff */
  /* 0x9e00-0x9fff */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x9e00-0x9e3f */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x9e40-0x9e7f */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x9e80-0x9ebf */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x9ec0-0x9eff */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x9f00-0x9f3f */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0x9f40-0x9f7f */
  0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, /* 0x9f80-0x9fbf */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 0x9fc0-0x9fff */
  /* 0xd600-0xd7ff */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0xd600-0xd63f */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0xd640-0xd67f */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0xd680-0xd6bf */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0xd6c0-0xd6ff */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0xd700-0xd73f */
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, /* 0xd740-0xd77f */
  0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, /* 0xd780-0xd7bf */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  /* 0xd7c0-0xd7ff */
};

static const signed char c_ident_ind[128] = {
   0,  1,  2,  3,  4,  5,  6,  7, /* 0x0000-0x0fff */
   8, -1, -1, -1, -1, -1, -1,  9, /* 0x1000-0x1fff */
  10, -1, -1, -1, -1, -1, -1, -1, /* 0x2000-0x2fff */
  11, -1, -1, -1, -1, -1, -1, -1, /* 0x3000-0x3fff */
  -1, -1, -1, -1, -1, -1, -1, -2, /* 0x4000-0x4fff */
  -2, -2, -2, -2, -2, -2, -2, -2, /* 0x5000-0x5fff */
  -2, -2, -2, -2, -2, -2, -2, -2, /* 0x6000-0x6fff */
  -2, -2, -2, -2, -2, -2, -2, -2, /* 0x7000-0x7fff */
  -2, -2, -2, -2, -2, -2, -2, -2, /* 0x8000-0x8fff */
  -2, -2, -2, -2, -2, -2, -2, 12, /* 0x9000-0x9fff */
  -1, -1, -1, -1, -1, -1, -2, -2, /* 0xa000-0xafff */
  -2, -2, -2, -2, -2, -2, -2, -2, /* 0xb000-0xbfff */
  -2, -2, -2, -2, -2, -2, -2, -2, /* 0xc000-0xcfff */
  -2, -2, -2, 13, -1, -1, -1, -1, /* 0xd000-0xdfff */
  -1, -1, -1, -1, -1, -1, -1, -1, /* 0xe000-0xefff */
  -1, -1, -1, -1, -1, -1, -1, -1  /* 0xf000-0xffff */
};

int is_c_identifier_part(unsigned int c)
{
  if (c < 0x10000) {
    int ind = c_ident_ind[c >> 9];
    if (ind >= 0)
      return (c_ident_data[64*ind + ((c >> 3) & 63)] >> (c & 7)) & 1;
    else
      return ~ind; /* -1 -> 0, -2 -> 1 */
  }
  return 0;
}
