/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux <klaux@student.uni-kl.de>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <SDL/SDL.h>
#include "timer.h"

#if __GNUC__ > 2
#include <ext/slist>
#else
#include <slist>
#endif

namespace uta {

#ifdef HAVE_GNU_CXX_SLIST
static __gnu_cxx::slist<Timer*> systemTimers;
#else // HAVE_GNU_CXX_SLIST
static std::slist<Timer*> systemTimers;
#endif // HAVE_GNU_CXX_SLIST

Timer::Timer(unsigned int mseconds) :
  running_(true),
  deltaT_(mseconds)
{
  systemTimers.push_front(this);
  theTime = SDL_GetTicks();
}

Timer::~Timer()
{
  systemTimers.remove(this);
}

void 
Timer::update(unsigned int now)
{
  if(!running_)
    return;

  unsigned int delta = now - theTime;
  if(delta >= deltaT_)
    {
      theTime = now;
      alarm1(delta - deltaT_);
      alarm();
    }
}

void
Timer::setInterval(unsigned int delta)
{
  deltaT_ = delta;
}

void
Timer::run()
{
  //enable timer and reset time
  running_ = true;
  theTime = SDL_GetTicks();
}

void
Timer::halt()
{
  running_ = false;
}

void
Timer::processAllTimers()
{
  
  unsigned int now = SDL_GetTicks();

#ifdef HAVE_GNU_CXX_SLIST
  __gnu_cxx::slist<Timer*>::iterator itr = systemTimers.begin();
#else // HAVE_GNU_CXX_SLIST
  std::slist<Timer*>::iterator itr = systemTimers.begin();
#endif // HAVE_GNU_CXX_SLIST
  while(itr != systemTimers.end())
    {
      (*itr)->update(now);
      itr++;
    }
}
}
