/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "rect.h"
#include "point.h"

#include <iostream>

namespace uta {

Rect Rect::invalid = Rect(0,0,-1,-1);
Rect Rect::empty = Rect(0,0,0,0);

Rect::Rect( int x, int y, int w, int h) :
  upperLeft_(x,y),
  lowerRight_(x+w, y+h)
{

}

Rect::Rect() :
  upperLeft_(0,0),
  lowerRight_(0,0)
{

}

// Rect::Rect ( const SDL_Rect &rect) :
//   upperLeft_(rect.x, rect.y),
//   lowerRight_(rect.x+rect.w, rect.y+rect.h)
// {
  
// }

Rect::Rect(const Point &upperLeft, const Point &lowerRight) :
  upperLeft_(upperLeft),
  lowerRight_(lowerRight)
{

}

Rect::~Rect()
{

}

// Rect::operator SDL_Rect*(void) const
// {
//   SDL_Rect *tmp = new SDL_Rect;
//   tmp->x = upperLeft().x;
//   tmp->y = upperLeft().y;
//   tmp->w = lowerRight().x -upperLeft().x ;
//   tmp->h = lowerRight().y -upperLeft().y ;
//   return tmp;
// }

bool
Rect::isEmpty() const
{
  return ( upperLeft_ == lowerRight_);
}

bool
Rect::isValid() const
{
  return (lowerRight() >= upperLeft());
}

bool
Rect::contains(const Point &p) const
{
  return (p >= upperLeft()) && (p < lowerRight());

}

bool
Rect::contains(const Rect &r) const 
{
  return contains(r.upperLeft()) && contains(r.lowerRight());
}

void
Rect::translate(int dx, int dy)
{
  upperLeft_.x += dx;
  upperLeft_.y += dy;
  lowerRight_.x += dx;
  lowerRight_.y += dy;
}

void 
Rect::warp(const Point &newUpperLeft)
{

  Point delta = upperLeft_ - newUpperLeft;
  
  upperLeft_ -= delta;
  lowerRight_ -= delta;
  
}

void
Rect::resize(int w, int h)
{
  lowerRight_ = upperLeft_+Point(w,h);
}


Rect
Rect::unite(const Rect &r) const
{
  Point ul(0,0);
  Point lr(-1, -1);

  if(r.isValid() && isValid())
    {
      r.upperLeft().x < upperLeft().x ?
	ul.x = r.upperLeft().x :
	ul.x = upperLeft().x;
      
      r.upperLeft().y < upperLeft().y ?
	ul.y = r.upperLeft().y :
	ul.y = upperLeft().y;
      
      r.lowerRight().x > lowerRight().x ?
	lr.x = r.lowerRight().x :
	lr.x = lowerRight().x;
      
      r.lowerRight().y > lowerRight().y ?
	lr.y = r.lowerRight().y :
	lr.y = lowerRight().y;
    }
  
  return Rect(ul, lr);

}

Rect 
Rect::intersect(const Rect &r) const
{
  Point ul(0,0);
  Point lr(-1, -1);
  Rect rect;

  if(r.isValid() && isValid())
    {
      r.upperLeft().x > upperLeft().x ?
	ul.x = r.upperLeft().x :
	ul.x = upperLeft().x;
      
      r.upperLeft().y > upperLeft().y ?
	ul.y = r.upperLeft().y :
	ul.y = upperLeft().y;
      
      r.lowerRight().x < lowerRight().x ?
	lr.x = r.lowerRight().x :
	lr.x = lowerRight().x;
      
      r.lowerRight().y < lowerRight().y ?
	lr.y = r.lowerRight().y :
	lr.y = lowerRight().y;
    }

  if((ul.x == lr.x) || (ul.y == lr.y))
    {
      lr.x = -1;
      lr.y = -1;
      ul.x = 0;
      ul.y = 0;
    }

  return Rect(ul, lr);
  
}

std::ostream&
operator<<(std::ostream& s, const Rect& p)
{
    s << "(" << p.upperLeft() << "," << p.lowerRight() << ")";
    return s;
}
}

