/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "progressdialog.h"
#include "application.h"
#include "resources.h"

namespace uta {

#define BAR_WIDTH (width()-30-32)

//this is a non-modal dialog

ProgressDialog::ProgressDialog() :
  Dialog(uapp->rootWindow()->width()/4,
	 (uapp->rootWindow()->height()-75-32)/2,
	 uapp->rootWindow()->width()/2,
	 75+32),
  percentage_(0)
{

  if(RES_AVAILABLE("progressdialog_color"))
    Widget::setColor(COLOR_RES("progressdialog_color"));
  if(RES_AVAILABLE("progressdialog_surface"))
    Widget::setBackground(SURFACE_RES("progressdialog_surface"));
  

  bar_ = new Widget(this, 15+16, 15+16, BAR_WIDTH, 25);
  info_ =new Label(this, 15+16, height()-35-16, BAR_WIDTH, 25);
  
  bar_->setColor(COLOR_RES("progressdialog_bar_color"));
  bar_->setBackground(SURFACE_RES("progressdialog_bar_surface"));

  
  Widget *border;
  Widget *edge;

  border = new Widget(this,0,0,width(),16);
  border->setBackground(SURFACE_RES("progressdialog_frame_h"));
  edge = new Widget(border,0,0,16,16);
  edge->setBackground(SURFACE_RES("progressdialog_frame_edge"));
  edge = new Widget(border,width()-16,0,16,16);
  edge->setBackground(SURFACE_RES("progressdialog_frame_edge"));
  border = new Widget(this,0,height()-16,width(),16);
  border->setBackground(SURFACE_RES("progressdialog_frame_h")); 
  edge = new Widget(border,width()-16,0,16,16);
  edge->setBackground(SURFACE_RES("progressdialog_frame_edge"));
  edge = new Widget(border,0,0,16,16);
  edge->setBackground(SURFACE_RES("progressdialog_frame_edge"));
  
  
  border = new Widget(this,0,16,16,height()-32);
  border->setBackground(SURFACE_RES("progressdialog_frame_v"));
  border = new Widget(this,width()-16,16,16,height()-32);
  border->setBackground(SURFACE_RES("progressdialog_frame_v"));

  bar_->resize(1+percentage_*BAR_WIDTH/100,25);

}




ProgressDialog::~ProgressDialog()
{
  remove();
}


void ProgressDialog::remove()
{
  accept();
}

void ProgressDialog::setValue(int data)
{
  percentage_ = data;

  if(percentage_ < 0)
    percentage_ = 0;
  if(percentage_ > 100)
     percentage_ = 100;

  bar_->resize(1+percentage_*BAR_WIDTH/100.0,25);  

  //global eventloop may not be running... so we have to update
  //manually 
  uapp->rootWindow()->sync();

}

void ProgressDialog::info(const char* data)
{
  info_->setText(data);
}
}

