/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux <klaux@student.uni-kl.de>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

// writtten May 1999


#ifndef _UTA_MIXER_H
#define _UTA_MIXER_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sigc++/signal_system.h>
#include "sample.h"
#include "music.h"


namespace uta {


///
class Mixer : public SigC::Object
{
//OBJECT
  
  ///
  friend class Music;

public:

  ///
  Mixer();
  ///
  ~Mixer();
  ///
  static Mixer* standardMixer;
  ///
  bool audioAvailable() { return audio_open_; };
  ///
  const Music* currentSong() const { return music_; }; 
  ///how many channels shall get processed
  int setActiveChannels(int);
  ///
  void setMusic(const char*);
  ///
  void startMusic();
  ///
  void stopMusic();
  ///
  void pauseMusic();
  ///
  void resumeMusic();
  ///
  void rewindMusic();
  ///
  void playSample(const char*);
  ///
  int setVolume(int);
  ///
  int setMusicVolume(int);

  /** Enable visualization / filtering hook.
      (@ref data)
   */
  void enableHook(bool);
  
  /**Signal data.
     When the visualization hook is enabled, this signals is emitted whenever
     new data is to be send to the sounddevice.
     @param: ptr and length of sample data.
  */
  SigC::Signal2<void, Uint8*, int> data;

 protected:

  ///
  int audio_open_;
  ///
  static void mixer_callback(void*, Uint8*, int);


#ifdef HAVE_MIXER

  ///
  int audio_rate_;
  ///
  Uint16 audio_format_;
  ///
  int audio_channels_;
  ///
  SDL_AudioSpec audioSpec_;
#endif

  ///
  const Music* music_;
};

}

#endif
