/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#undef DEBUG

#include "label.h"
#include "debug.h"
#include "resources.h"

#include <assert.h>

namespace uta {

Label::Label(Widget* parent, int x, int y, int w, int h, const Font *font) :
  Widget(parent, x, y , w, h),
  labelFont_(font),
  align_(ALIGN_CENTER)
{
  if(labelFont_ == 0)
    labelFont_ = FONT_RES("text_font");

  if(RES_AVAILABLE("text_color"))
    if(RES_AVAILABLE("text_background"))
      setTextColor(COLOR_RES("text_color"), COLOR_RES("text_background"));
    else
      setTextColor(COLOR_RES("text_color"));
  else
    setTextColor(labelFont_->fontColor(), labelFont_->fadeColor());

  if(RES_AVAILABLE("label_color"))
    Widget::setColor(COLOR_RES("label_color"));
  if(RES_AVAILABLE("label_surface"))
    Widget::setBackground(SURFACE_RES("label_surface"),false);
}

Label::~Label()
{
  //EMPTY
}

void
Label::create()
{

  debugN(17,cerr<<"Label blitting text: \""<<labelText_<<"\""<<endl;);


  Widget::create();
  

  Surface *text = labelFont_->getString(labelText_);
 
  if(fontPal_.size() != 0)
    text->setPalette(fontPal_);
  
  Rect dest;

  switch(align_)
    {
    case ALIGN_CENTER:
      dest = Rect((surface_->width()-text->width())/2,
		   (surface_->height()-text->height())/2,
		   text->width(), text->height());
      break;
    case ALIGN_LEFT:
      dest = Rect(0,
		   (surface_->height()-text->height())/2,
		   text->width(), text->height());
      break;
    case ALIGN_RIGHT:
      dest = Rect((surface_->width()-text->width()),
		   (surface_->height()-text->height())/2,
		   text->width(), text->height());
      break;
    }

  text->blit(surface_, dest);


  delete text;

}


void Label::setText(const char* data)
{
  //cerr << "setText(" << data << ")" <<endl;
  labelText_ = data;
  needsUpdate_ = true;
}

 
void 
Label::setTextColor(const Color& fontCol, const Color& fadeCol)
{

  int rdiff = fontCol.r - fadeCol.r;
  int gdiff = fontCol.g - fadeCol.g;
  int bdiff = fontCol.b - fadeCol.b;
  int adiff = fontCol.a - fadeCol.a;

  int r = fadeCol.r;
  int g = fadeCol.g;
  int b = fadeCol.b;
  int a = fadeCol.a;

  fontPal_.clear();
  fontPal_.push_back(transparent);
 
  for(unsigned char num=1; num < 5; num++)
    fontPal_.push_back(Color(r + num * rdiff/4,
			     g + num * gdiff/4,
			     b + num * bdiff/4,
			     a + num * adiff/4));
  
  needsUpdate_ = true;
}

}

