/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include <assert.h>

#include "focus.h"
#include "widget.h"

using namespace uta;

//initialize static member
Widget* Focus::owner = NULL;

bool
Focus::release(Widget* candidat)
{
  if(candidat == owner)
    {
      owner = NULL;
      return true;
    }
  return false;
}

bool
Focus::grab(Widget* candidat)
{
  assert(candidat);

  //assume success
  bool got_it = true;

  //if some other widget has owned the focus by now, 
  //tell it that it has to release the focus:
  if(owner)
    got_it = owner->releaseFocus();

  //if we obtained the focus, set the new owner
  if(got_it)
    owner = candidat;

  return got_it;
}
  
