/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "event.h"
#include <ctype.h>

namespace uta {

char KeyEvent::ascii() const
{
  return (char)(unicode_ & 0x007F); 
}
  
Event *createUEvent(const SDL_Event* event)
{
  
  if(event->type == SDL_KEYDOWN || event->type == SDL_KEYUP)
    {
      int state = 0;
      if (event->key.state == SDL_PRESSED)
	state = KeyEvent::PRESSED;

      if (event->key.state == SDL_RELEASED)
	state = KeyEvent::RELEASED;

      return new KeyEvent(event->key.keysym.sym,
			   event->key.keysym.mod,
			   state,
			   event->key.keysym.unicode);
    };

  if(event->type == SDL_MOUSEMOTION)
    {
      return new MouseEvent(Point(event->motion.x, event->motion.y));
    };

  if(event->type == SDL_MOUSEBUTTONDOWN ||
     event->type == SDL_MOUSEBUTTONUP )
    {
      int state = 0;
      int buttons = 0;
      if (event->button.state == SDL_PRESSED)
	state = ButtonEvent::PRESSED;

      if (event->button.state == SDL_RELEASED)
	state = ButtonEvent::RELEASED;

      if (event->button.button == 1)
	buttons = ButtonEvent::BUTTON_LEFT;

      if (event->button.button == 2)
	buttons = ButtonEvent::BUTTON_MIDDLE;

      if (event->button.button == 3)
	buttons = ButtonEvent::BUTTON_RIGHT;

      return new ButtonEvent(state,
			      buttons,
			      Point(event->button.x, event->button.y));
    }
  if(event->type == SDL_QUIT)
    {
      return new Event(Event::QUIT);
    }

  if(event->type == SDL_ACTIVEEVENT)
    {
      if(event->active.gain)
	{
	  if ( event->active.state & SDL_APPACTIVE )
	    return new Event(Event::RESTORED);
	  if ( event->active.state & SDL_APPINPUTFOCUS )
	    return new Event(Event::GOTFOCUS);    	      	      	      
	}
      else
	{
	  if ( event->active.state & SDL_APPACTIVE )
	    return new Event(Event::ICONIFIED);
	  if ( event->active.state & SDL_APPINPUTFOCUS )
	    return new Event(Event::LOSTFOCUS);
	}
    }

  return new Event(Event::NKNOWN);
}

  
}

