/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "dialog.h"
#include "application.h"
#include "resources.h"

namespace uta {

Dialog::Dialog(int x, int y, int w, int h, bool modal) :
  Widget(Application::Instance->rootWindow(),x,y,w,h),
  modal_(modal),
  result_(OK),
  open_(false)
{

  if(RES_AVAILABLE("dialog_color"))
    Widget::setColor(COLOR_RES("dialog_color"));

  if(RES_AVAILABLE("dialog_surface"))
    Widget::setBackground(SURFACE_RES("dialog_surface"));

  //immediately hide does not work ...
  hide();
}



Dialog::~Dialog()
{
  open_ = false;
}

int
Dialog::exec()
{
  show();
//  uapp->keepAlive();

  uapp->rootWindow()->sync();

  Application::Instance->rootWindow()->runDialog(this);
  Application::Instance->soundMapper()->open();
  

  open_ = true;

  if(modal_)
    {
      //local event loop
      //      cerr << "entering local eventloop ..."<<endl;

      while(uapp->keepAlive() && open_);

      //cerr << "leaving local eventloop ..." << endl;
  
//      do not close !!!    
//      close();
      Application::Instance->rootWindow()->closeDialog();
      Application::Instance->soundMapper()->close();
    }

  //cerr << "returning from exec() " << endl;

  return result_;
}


void Dialog::reject()
{
  hide();
  rejected();
  done(CANCEL);
   
  if(!modal_)
    {
//      close();
      Application::Instance->rootWindow()->closeDialog();
      Application::Instance->soundMapper()->close();
    }

  result_ = CANCEL;
  open_ = false;
}

void Dialog::accept()
{
  hide();
  accepted();
  done(OK);

  if(!modal_)
    {
//      close();
      Application::Instance->rootWindow()->closeDialog();
      Application::Instance->soundMapper()->close();
    }

  result_ = OK;
  open_ = false;
}

}

