/* MACRO definitions used by blitters.cc 


   This file is a interal header file, only needed to build the library.
   It should not get installed on the target system.

*/

/* This macro takes a dword in mm2 (containing 2 16bit pixels)
   and unpacks the color components to mm2, mm3, mm4 
   It expects the color masks in mm5, mm6, mm7.
*/
#define UNPACK_32_RGB565_RGB888\
  /* and copy the value to mm3 and mm4 */ \
  movq_r2r(mm2, mm3); \
  movq_r2r(mm2, mm4); \
  \
  /* mask out red and shift */ \
  pand_r2r(mm5,mm2); \
  psrld_i2r(8,mm2); \
  /* mask out green and shift */ \
  pand_r2r(mm6,mm3); \
  psrld_i2r(3,mm3); \
  /* mask out blue and shift  */ \
  pand_r2r(mm7,mm4); \
  pslld_i2r(3,mm4);
 
/* This macro takes a qword in mm2 (containing 4 16bit pixels)
   and unpacks the color components to mm2, mm3, mm4 
   It expects the color masks in mm5, mm6, mm7.
*/
#define UNPACK_64_RGB565_RGB888\
  /* and copy the value to mm3 and mm4 */ \
  movq_r2r(mm2, mm3); \
  movq_r2r(mm2, mm4); \
  \
  /* mask out red and shift */ \
  pand_r2r(mm5,mm2); \
  psrlq_i2r(8,mm2); \
  /* mask out green and shift */ \
  pand_r2r(mm6,mm3); \
  psrlq_i2r(3,mm3); \
  /* mask out blue and shift  */ \
  pand_r2r(mm7,mm4); \
  psllq_i2r(3,mm4); 

/* This macro takes the color components from mm2, mm3, mm4
   and packs these into 2 pixels (a 16bit) in mm2.
   It expects the color masks in mm5, mm6, mm7.
*/
#define PACK_32_RGB888_RGB565\
  /* shift values back to the correct position */ \
  psrld_i2r(3,mm4); \
  pslld_i2r(3,mm3); \
  pslld_i2r(8,mm2); \
  \
  /* mask out unwanted bits (using the color masks) */ \
  pand_r2r(mm5,mm2); \
  pand_r2r(mm6,mm3); \
  pand_r2r(mm7,mm4); \
  \
  /* pack color components again */ \
  por_r2r(mm3,mm2); \
  por_r2r(mm4,mm2); 

/* This macro takes the color components from mm2, mm3, mm4
   and packs these into 4 pixels (a 16bit) in mm2.
   It expects the color masks in mm5, mm6, mm7.
*/
#define PACK_64_RGB888_RGB565\
  /* shift values back to the correct position */ \
  psrlq_i2r(3,mm4); \
  psllq_i2r(3,mm3); \
  psllq_i2r(8,mm2); \
  \
  /* mask out unwanted bits (using the color masks) */ \
  pand_r2r(mm5,mm2); \
  pand_r2r(mm6,mm3); \
  pand_r2r(mm7,mm4); \
  \
  /* pack color components again */ \
  por_r2r(mm3,mm2); \
  por_r2r(mm4,mm2); 

/* Load the color Mask in the qword registers mm5,mm6,mm7
   Each register will contain the color mask in each of
   its words.
*/
#define PREPARE_64_COLOR_MASKS(rMask, gMask, bMask) \
  mmx_t RMask, GMask, BMask; \
  RMask.uw[0] = rMask; \
  RMask.uw[1] = rMask; \
  RMask.uw[2] = rMask; \
  RMask.uw[3] = rMask; \
  GMask.uw[0] = gMask; \
  GMask.uw[1] = gMask; \
  GMask.uw[2] = gMask; \
  GMask.uw[3] = gMask; \
  BMask.uw[0] = bMask; \
  BMask.uw[1] = bMask; \
  BMask.uw[2] = bMask; \
  BMask.uw[3] = bMask; \
  \
  movq_m2r(RMask, mm5); \
  movq_m2r(GMask, mm6); \
  movq_m2r(BMask, mm7); 
/* Load the color Mask in the qword registers mm5,mm6,mm7
   Each register will contain the color mask in each of
   its words.
*/

#define PREPARE_64interleave_COLOR_MASKS(rMask, gMask, bMask) \
  mmx_t RMask, GMask, BMask; \
  RMask.uw[0] = rMask; \
  RMask.uw[1] = 0; \
  RMask.uw[2] = rMask; \
  RMask.uw[3] = 0; \
  GMask.uw[0] = gMask; \
  GMask.uw[1] = 0; \
  GMask.uw[2] = gMask; \
  GMask.uw[3] = 0; \
  BMask.uw[0] = bMask; \
  BMask.uw[1] = 0; \
  BMask.uw[2] = bMask; \
  BMask.uw[3] = 0; \
  \
  movq_m2r(RMask, mm5); \
  movq_m2r(GMask, mm6); \
  movq_m2r(BMask, mm7); 
