#ifndef _USBI_H_
#define _USBI_H_

#include "usb.h"

#include "error.h"

extern int usb_debug;

struct usb_dev_handle {
  int fd;

  struct usb_bus *bus;
  struct usb_device *device;

  int config;
  int interface;
  int altsetting;

  /* Added by RMT so implementations can store other per-open-device data */
  void *impl_info;
};

/* OS specific routines */
int usb_find_devices_on_bus(struct usb_bus *bus);
void usb_os_init(void);
int usb_os_open(usb_dev_handle *dev);
int usb_os_close(usb_dev_handle *dev);

#endif /* _USBI_H_ */

