/* tape_accessors.c: accessor functions for libspectrum_tape_block
   Copyright (c) 2003 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

/* NB: this file is autogenerated from tape_accessors.txt by tape_accessors.pl */

#include "internals.h"
#include "tape_block.h"

libspectrum_dword
libspectrum_tape_block_bit_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: return block->types.raw_data.bit_length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_bit_length",
        block->type
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_bit0_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.bit0_length;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.bit0_length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_bit0_length",
        block->type
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_bit1_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.bit1_length;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.bit1_length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_bit1_length",
        block->type
      );
      return -1;
  }
}

size_t
libspectrum_tape_block_bits_in_last_byte( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.bits_in_last_byte;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: return block->types.raw_data.bits_in_last_byte;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.bits_in_last_byte;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_bits_in_last_byte",
        block->type
      );
      return -1;
  }
}

size_t
libspectrum_tape_block_count( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_TONE: return block->types.pure_tone.pulses;
    case LIBSPECTRUM_TAPE_BLOCK_PULSES: return block->types.pulses.count;
    case LIBSPECTRUM_TAPE_BLOCK_LOOP_START: return block->types.loop_start.count;
    case LIBSPECTRUM_TAPE_BLOCK_SELECT: return block->types.select.count;
    case LIBSPECTRUM_TAPE_BLOCK_ARCHIVE_INFO: return block->types.archive_info.count;
    case LIBSPECTRUM_TAPE_BLOCK_HARDWARE: return block->types.hardware.count;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_count",
        block->type
      );
      return -1;
  }
}

libspectrum_byte*
libspectrum_tape_block_data( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_CUSTOM: return block->types.custom.data;
    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.data;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: return block->types.raw_data.data;
    case LIBSPECTRUM_TAPE_BLOCK_ROM: return block->types.rom.data;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.data;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_data",
        block->type
      );
      return NULL;
  }
}

size_t
libspectrum_tape_block_data_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_CUSTOM: return block->types.custom.length;
    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.length;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: return block->types.raw_data.length;
    case LIBSPECTRUM_TAPE_BLOCK_ROM: return block->types.rom.length;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_data_length",
        block->type
      );
      return -1;
  }
}

int
libspectrum_tape_block_ids( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_ARCHIVE_INFO: return block->types.archive_info.ids[ index ];
    case LIBSPECTRUM_TAPE_BLOCK_HARDWARE: return block->types.hardware.ids[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_ids",
        block->type
      );
      return -1;
  }
}

int
libspectrum_tape_block_offset( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_JUMP: return block->types.jump.offset;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_offset",
        block->type
      );
      return 0;
  }
}

int
libspectrum_tape_block_offsets( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_SELECT: return block->types.select.offsets[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_offsets",
        block->type
      );
      return 0;
  }
}

libspectrum_dword
libspectrum_tape_block_pause( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_MESSAGE: return block->types.message.time;
    case LIBSPECTRUM_TAPE_BLOCK_PAUSE: return block->types.pause.length;
    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.pause;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: return block->types.raw_data.pause;
    case LIBSPECTRUM_TAPE_BLOCK_ROM: return block->types.rom.pause;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.pause;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_pause",
        block->type
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_pilot_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.pilot_length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_pilot_length",
        block->type
      );
      return -1;
  }
}

size_t
libspectrum_tape_block_pilot_pulses( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.pilot_pulses;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_pilot_pulses",
        block->type
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_pulse_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_TONE: return block->types.pure_tone.length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_pulse_length",
        block->type
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_pulse_lengths( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PULSES: return block->types.pulses.lengths[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_pulse_lengths",
        block->type
      );
      return -1;
  }
}

libspectrum_tape_state_type
libspectrum_tape_block_state( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.state;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: return block->types.raw_data.state;
    case LIBSPECTRUM_TAPE_BLOCK_ROM: return block->types.rom.state;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.state;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_state",
        block->type
      );
      return LIBSPECTRUM_TAPE_STATE_INVALID;
  }
}

libspectrum_dword
libspectrum_tape_block_sync1_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.sync1_length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_sync1_length",
        block->type
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_sync2_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.sync2_length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_sync2_length",
        block->type
      );
      return -1;
  }
}

libspectrum_byte*
libspectrum_tape_block_text( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GROUP_START: return block->types.group_start.name;
    case LIBSPECTRUM_TAPE_BLOCK_COMMENT: return block->types.comment.text;
    case LIBSPECTRUM_TAPE_BLOCK_MESSAGE: return block->types.message.text;
    case LIBSPECTRUM_TAPE_BLOCK_CUSTOM: return block->types.custom.description;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_text",
        block->type
      );
      return NULL;
  }
}

libspectrum_byte*
libspectrum_tape_block_texts( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_ARCHIVE_INFO: return block->types.archive_info.strings[ index ];
    case LIBSPECTRUM_TAPE_BLOCK_SELECT: return block->types.select.descriptions[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_texts",
        block->type
      );
      return NULL;
  }
}

int
libspectrum_tape_block_types( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_HARDWARE: return block->types.hardware.types[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_types",
        block->type
      );
      return -1;
  }
}

int
libspectrum_tape_block_values( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_HARDWARE: return block->types.hardware.values[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type %d given to libspectrum_tape_block_values",
        block->type
      );
      return -1;
  }
}

