#!/bin/sh

# Copyright (C) 2003 Erik de Castro Lopo <erikd@zip.com.au>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#----------------------------------------------------------------
# These are all of the public functions exported from libsndfile.

ALL_SYMBOLS=( \
	sf_close \
	sf_command \
	sf_error \
	sf_error_number \
	sf_error_str \
	sf_format_check \
	sf_open \
	sf_open_fd \
	sf_perror \
	sf_read_double \
	sf_read_float \
	sf_read_int \
	sf_read_raw \
	sf_read_short \
	sf_readf_double \
	sf_readf_float \
	sf_readf_int \
	sf_readf_short \
	sf_seek \
	sf_strerror \
	sf_write_double \
	sf_write_float \
	sf_write_int \
	sf_write_raw \
	sf_write_short \
	sf_writef_double \
	sf_writef_float \
	sf_writef_int \
	sf_writef_short \
	sf_get_string \
	sf_set_string \
	)
#-------------------------------------------------------------------------------

linux_symbols () {
	echo "# Auto-generated by $0"
	echo
	echo "libsndfile.so.$VERSION"
	echo "{"
	echo "  global:"
	for x in ${ALL_SYMBOLS[@]} ; do
		echo "    $x ;"
		done
	echo "  local:"
	echo "    * ;"
	echo "} ;"
	echo
}

darwin_symbols () {
	echo "# Auto-generated by $0"
	echo
	for x in ${ALL_SYMBOLS[@]} ; do
		echo "_$x"
		done
	echo
}

no_symbols () {
	OS=`uname`
	echo
	echo "No known way of restricting exported symbols on $OS."
	echo "If you know a way, please contact the author."
	echo
}

#-------------------------------------------------------------------------------

if test $# -ne 2 ; then
	echo
	echo "Usage : $0 <target OS name> <libsndfile version>."
	echo
	echo "    Currently supported values for target OS are:"
	echo "          linux"
	echo "          darwin     (ie MacOSX)"
	echo
	exit 1
	fi

VERSION=`echo $2 | sed -re "s/\.[a-z0-9]+$//"`
OS_NAME=$1

case $OS_NAME in
	linux*)
		linux_symbols
		;;
	darwin*)
		darwin_symbols
		;;
	*)
		no_symbols
		;;
	esac

exit 0


# Do not edit or modify anything in this comment block.
# The arch-tag line is a file identity tag for the GNU Arch 
# revision control system.
#
# arch-tag: 5814f35c-318f-4023-a0c3-d9cf7c9e5f6c

