
/*****
*
* Copyright (C) 2001,2002,2003,2004,2005 PreludeIDS Technologies. All Rights Reserved.
* Author: Yoann Vandoorselaere <yoann.v@prelude-ids.com>
* Author: Nicolas Delon <nicolas.delon@prelude-ids.com>
*
* This file is part of the Prelude library.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/* Auto-generated by the GenerateIDMEFMessageReadC package */
#include "config.h"

#include <stdio.h>
#include <unistd.h>

#define PRELUDE_ERROR_SOURCE_DEFAULT PRELUDE_ERROR_SOURCE_IDMEF_MESSAGE_READ
#include "prelude-error.h"
#include "prelude-inttypes.h"
#include "prelude-list.h"
#include "prelude-extract.h"
#include "prelude-io.h"
#include "idmef-message-id.h"
#include "idmef.h"
#include "idmef-tree-wrap.h"

#include "idmef-message-read.h"

#define prelude_extract_string_safe(out, buf, len, msg) extract_string_safe_f(__FUNCTION__, __LINE__, out, buf, len)

static inline int extract_string_safe_f(const char *f, int line, prelude_string_t **out, char *buf, size_t len)
{
        /*
         * we use len - 1 since len is supposed to include   to avoid making a dup.
         */

        return prelude_string_new_ref_fast(out, buf, len - 1);
}


static inline int prelude_extract_time_safe(idmef_time_t **out, void *buf, size_t len, prelude_msg_t *msg)
{
        int ret;

        /*
         * sizeof(sec) + sizeof(usec) + sizeof(gmt offset).
         */
        if ( len != 12 )
                return prelude_error_make(PRELUDE_ERROR_SOURCE_EXTRACT, PRELUDE_ERROR_INVAL_IDMEF_TIME);

        ret = idmef_time_new(out);
        if ( ret < 0 )
                return ret;

        idmef_time_set_sec(*out, prelude_extract_uint32(buf));
        idmef_time_set_usec(*out, prelude_extract_uint32((unsigned char *) buf + 4));
        idmef_time_set_gmt_offset(*out, prelude_extract_int32((unsigned char *) buf + 8));

        return 0;
}


static inline int prelude_extract_data_safe(idmef_data_t **out, void *buf, uint32_t len, prelude_msg_t *msg)
{
        int ret;
	uint8_t tag;
	idmef_data_type_t type = 0;

        ret = prelude_extract_uint32_safe(&type, buf, len);
	if ( ret < 0 )
		return ret;

        ret = prelude_msg_get(msg, &tag, &len, &buf);
	if ( ret < 0 )
		return ret;

	*out = NULL;

	switch ( type ) {
	case IDMEF_DATA_TYPE_CHAR: {
		uint8_t tmp = 0;
  
                ret = prelude_extract_uint8_safe(&tmp, buf, len);
		if ( ret < 0 )
			return ret;

		ret = idmef_data_new_char(out, (char) tmp);
		break;
	}

	case IDMEF_DATA_TYPE_BYTE: {
		uint8_t tmp = 0;

                ret = prelude_extract_uint8_safe(&tmp, buf, len);
		if ( ret < 0 )
			return ret;

		ret = idmef_data_new_byte(out, tmp);
		break;
	}

	case IDMEF_DATA_TYPE_UINT32: {
		uint32_t tmp = 0;

                ret = prelude_extract_uint32_safe(&tmp, buf, len);
		if ( ret < 0 )
			return ret;

		ret = idmef_data_new_uint32(out, tmp);
		break;
	}

	case IDMEF_DATA_TYPE_UINT64: {
		uint64_t tmp = 0;

                ret = prelude_extract_uint64_safe(&tmp, buf, len);
                if ( ret < 0 )
			return ret;

		ret = idmef_data_new_uint64(out, tmp);
		break;
	}

	case IDMEF_DATA_TYPE_FLOAT: {
		float tmp = 0;

                ret = prelude_extract_float_safe(&tmp, buf, len);
		if ( ret < 0 )
			return ret;

		ret = idmef_data_new_float(out, tmp);
		break;
	}

        case IDMEF_DATA_TYPE_BYTE_STRING: {
                ret = idmef_data_new_ptr_ref_fast(out, type, buf, len);
                break;
        }

	case IDMEF_DATA_TYPE_CHAR_STRING: {
		const char *tmp = NULL;

                ret = prelude_extract_characters_safe(&tmp, buf, len);
		if ( ret < 0 )
			return ret;

		ret = idmef_data_new_ptr_ref_fast(out, type, tmp, len);
		break;		
	}

	case IDMEF_DATA_TYPE_UNKNOWN:
		/* nop */;
	}

	return ret;
}



/**
 * idmef_additional_data_read:
 * @additional_data: Pointer to a #idmef_additional_data_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_additional_data from the @msg message, and 
 * store it into @additional_data.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_additional_data_read(idmef_additional_data_t *additional_data, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_ADDITIONAL_DATA_TYPE: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_additional_data_set_type(additional_data, tmp);
				break;
			}

			case IDMEF_MSG_ADDITIONAL_DATA_MEANING: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_additional_data_set_meaning(additional_data, tmp);
				break;
			}

			case IDMEF_MSG_ADDITIONAL_DATA_DATA: {
                                idmef_data_t *tmp = NULL;

                                ret = prelude_extract_data_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_additional_data_set_data(additional_data, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_additional_data_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_reference_read:
 * @reference: Pointer to a #idmef_reference_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_reference from the @msg message, and 
 * store it into @reference.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_reference_read(idmef_reference_t *reference, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_REFERENCE_ORIGIN: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_reference_set_origin(reference, tmp);
				break;
			}

			case IDMEF_MSG_REFERENCE_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_reference_set_name(reference, tmp);
				break;
			}

			case IDMEF_MSG_REFERENCE_URL: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_reference_set_url(reference, tmp);
				break;
			}

			case IDMEF_MSG_REFERENCE_MEANING: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_reference_set_meaning(reference, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_reference_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_classification_read:
 * @classification: Pointer to a #idmef_classification_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_classification from the @msg message, and 
 * store it into @classification.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_classification_read(idmef_classification_t *classification, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_CLASSIFICATION_IDENT: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_classification_set_ident(classification, tmp);
				break;
			}

			case IDMEF_MSG_CLASSIFICATION_TEXT: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_classification_set_text(classification, tmp);
				break;
			}

			case IDMEF_MSG_REFERENCE_TAG: {
                                int ret;
				idmef_reference_t *tmp = NULL;

				ret = idmef_classification_new_reference(classification, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_reference_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_classification_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_user_id_read:
 * @user_id: Pointer to a #idmef_user_id_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_user_id from the @msg message, and 
 * store it into @user_id.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_user_id_read(idmef_user_id_t *user_id, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_USER_ID_IDENT: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_user_id_set_ident(user_id, tmp);
				break;
			}

			case IDMEF_MSG_USER_ID_TYPE: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_user_id_set_type(user_id, tmp);
				break;
			}

			case IDMEF_MSG_USER_ID_TTY: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_user_id_set_tty(user_id, tmp);
				break;
			}

			case IDMEF_MSG_USER_ID_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_user_id_set_name(user_id, tmp);
				break;
			}

			case IDMEF_MSG_USER_ID_NUMBER: {
                                uint32_t tmp = 0;

                                ret = prelude_extract_uint32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_user_id_set_number(user_id, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_user_id_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_user_read:
 * @user: Pointer to a #idmef_user_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_user from the @msg message, and 
 * store it into @user.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_user_read(idmef_user_t *user, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_USER_IDENT: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_user_set_ident(user, tmp);
				break;
			}

			case IDMEF_MSG_USER_CATEGORY: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_user_set_category(user, tmp);
				break;
			}

			case IDMEF_MSG_USER_ID_TAG: {
                                int ret;
				idmef_user_id_t *tmp = NULL;

				ret = idmef_user_new_user_id(user, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_user_id_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_user_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_address_read:
 * @address: Pointer to a #idmef_address_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_address from the @msg message, and 
 * store it into @address.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_address_read(idmef_address_t *address, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_ADDRESS_IDENT: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_address_set_ident(address, tmp);
				break;
			}

			case IDMEF_MSG_ADDRESS_CATEGORY: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_address_set_category(address, tmp);
				break;
			}

			case IDMEF_MSG_ADDRESS_VLAN_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_address_set_vlan_name(address, tmp);
				break;
			}

			case IDMEF_MSG_ADDRESS_VLAN_NUM: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_address_set_vlan_num(address, tmp);
				break;
			}

			case IDMEF_MSG_ADDRESS_ADDRESS: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_address_set_address(address, tmp);
				break;
			}

			case IDMEF_MSG_ADDRESS_NETMASK: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_address_set_netmask(address, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_address_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_process_read:
 * @process: Pointer to a #idmef_process_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_process from the @msg message, and 
 * store it into @process.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_process_read(idmef_process_t *process, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_PROCESS_IDENT: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_process_set_ident(process, tmp);
				break;
			}

			case IDMEF_MSG_PROCESS_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_process_set_name(process, tmp);
				break;
			}

			case IDMEF_MSG_PROCESS_PID: {
                                uint32_t tmp = 0;

                                ret = prelude_extract_uint32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_process_set_pid(process, tmp);
				break;
			}

			case IDMEF_MSG_PROCESS_PATH: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_process_set_path(process, tmp);
				break;
			}

			case IDMEF_MSG_PROCESS_ARG: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_process_set_arg(process, tmp, -1);
				break;
			}

			case IDMEF_MSG_PROCESS_ENV: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_process_set_env(process, tmp, -1);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_process_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_web_service_read:
 * @web_service: Pointer to a #idmef_web_service_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_web_service from the @msg message, and 
 * store it into @web_service.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_web_service_read(idmef_web_service_t *web_service, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_WEB_SERVICE_URL: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_web_service_set_url(web_service, tmp);
				break;
			}

			case IDMEF_MSG_WEB_SERVICE_CGI: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_web_service_set_cgi(web_service, tmp);
				break;
			}

			case IDMEF_MSG_WEB_SERVICE_HTTP_METHOD: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_web_service_set_http_method(web_service, tmp);
				break;
			}

			case IDMEF_MSG_WEB_SERVICE_ARG: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_web_service_set_arg(web_service, tmp, -1);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_web_service_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_snmp_service_read:
 * @snmp_service: Pointer to a #idmef_snmp_service_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_snmp_service from the @msg message, and 
 * store it into @snmp_service.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_snmp_service_read(idmef_snmp_service_t *snmp_service, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_SNMP_SERVICE_OID: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_snmp_service_set_oid(snmp_service, tmp);
				break;
			}

			case IDMEF_MSG_SNMP_SERVICE_MESSAGE_PROCESSING_MODEL: {
                                uint32_t tmp = 0;

                                ret = prelude_extract_uint32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_snmp_service_set_message_processing_model(snmp_service, tmp);
				break;
			}

			case IDMEF_MSG_SNMP_SERVICE_SECURITY_MODEL: {
                                uint32_t tmp = 0;

                                ret = prelude_extract_uint32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_snmp_service_set_security_model(snmp_service, tmp);
				break;
			}

			case IDMEF_MSG_SNMP_SERVICE_SECURITY_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_snmp_service_set_security_name(snmp_service, tmp);
				break;
			}

			case IDMEF_MSG_SNMP_SERVICE_SECURITY_LEVEL: {
                                uint32_t tmp = 0;

                                ret = prelude_extract_uint32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_snmp_service_set_security_level(snmp_service, tmp);
				break;
			}

			case IDMEF_MSG_SNMP_SERVICE_CONTEXT_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_snmp_service_set_context_name(snmp_service, tmp);
				break;
			}

			case IDMEF_MSG_SNMP_SERVICE_CONTEXT_ENGINE_ID: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_snmp_service_set_context_engine_id(snmp_service, tmp);
				break;
			}

			case IDMEF_MSG_SNMP_SERVICE_COMMAND: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_snmp_service_set_command(snmp_service, tmp);
				break;
			}

			case IDMEF_MSG_SNMP_SERVICE_COMMUNITY: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_snmp_service_set_community(snmp_service, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_snmp_service_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_service_read:
 * @service: Pointer to a #idmef_service_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_service from the @msg message, and 
 * store it into @service.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_service_read(idmef_service_t *service, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_SERVICE_IDENT: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_service_set_ident(service, tmp);
				break;
			}

			case IDMEF_MSG_SERVICE_IP_VERSION: {
                                uint8_t tmp = 0;

                                ret = prelude_extract_uint8_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_service_set_ip_version(service, tmp);
				break;
			}

			case IDMEF_MSG_SERVICE_IANA_PROTOCOL_NUMBER: {
                                uint8_t tmp = 0;

                                ret = prelude_extract_uint8_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_service_set_iana_protocol_number(service, tmp);
				break;
			}

			case IDMEF_MSG_SERVICE_IANA_PROTOCOL_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_service_set_iana_protocol_name(service, tmp);
				break;
			}

			case IDMEF_MSG_SERVICE_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_service_set_name(service, tmp);
				break;
			}

			case IDMEF_MSG_SERVICE_PORT: {
                                uint16_t tmp = 0;

                                ret = prelude_extract_uint16_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_service_set_port(service, tmp);
				break;
			}

			case IDMEF_MSG_SERVICE_PORTLIST: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_service_set_portlist(service, tmp);
				break;
			}

			case IDMEF_MSG_SERVICE_PROTOCOL: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_service_set_protocol(service, tmp);
				break;
			}

			case IDMEF_MSG_WEB_SERVICE_TAG: {
                                int ret;
				idmef_web_service_t *tmp = NULL;

				ret = idmef_service_new_web_service(service, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_web_service_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_SNMP_SERVICE_TAG: {
                                int ret;
				idmef_snmp_service_t *tmp = NULL;

				ret = idmef_service_new_snmp_service(service, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_snmp_service_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_service_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_node_read:
 * @node: Pointer to a #idmef_node_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_node from the @msg message, and 
 * store it into @node.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_node_read(idmef_node_t *node, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_NODE_IDENT: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_node_set_ident(node, tmp);
				break;
			}

			case IDMEF_MSG_NODE_CATEGORY: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_node_set_category(node, tmp);
				break;
			}

			case IDMEF_MSG_NODE_LOCATION: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_node_set_location(node, tmp);
				break;
			}

			case IDMEF_MSG_NODE_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_node_set_name(node, tmp);
				break;
			}

			case IDMEF_MSG_ADDRESS_TAG: {
                                int ret;
				idmef_address_t *tmp = NULL;

				ret = idmef_node_new_address(node, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_address_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_node_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_source_read:
 * @source: Pointer to a #idmef_source_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_source from the @msg message, and 
 * store it into @source.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_source_read(idmef_source_t *source, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_SOURCE_IDENT: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_source_set_ident(source, tmp);
				break;
			}

			case IDMEF_MSG_SOURCE_SPOOFED: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_source_set_spoofed(source, tmp);
				break;
			}

			case IDMEF_MSG_SOURCE_INTERFACE: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_source_set_interface(source, tmp);
				break;
			}

			case IDMEF_MSG_NODE_TAG: {
                                int ret;
				idmef_node_t *tmp = NULL;

				ret = idmef_source_new_node(source, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_node_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_USER_TAG: {
                                int ret;
				idmef_user_t *tmp = NULL;

				ret = idmef_source_new_user(source, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_user_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_PROCESS_TAG: {
                                int ret;
				idmef_process_t *tmp = NULL;

				ret = idmef_source_new_process(source, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_process_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_SERVICE_TAG: {
                                int ret;
				idmef_service_t *tmp = NULL;

				ret = idmef_source_new_service(source, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_service_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_source_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_file_access_read:
 * @file_access: Pointer to a #idmef_file_access_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_file_access from the @msg message, and 
 * store it into @file_access.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_file_access_read(idmef_file_access_t *file_access, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_USER_ID_TAG: {
                                int ret;
				idmef_user_id_t *tmp = NULL;

				ret = idmef_file_access_new_user_id(file_access, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_user_id_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_FILE_ACCESS_PERMISSION: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_file_access_set_permission(file_access, tmp, -1);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_file_access_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_inode_read:
 * @inode: Pointer to a #idmef_inode_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_inode from the @msg message, and 
 * store it into @inode.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_inode_read(idmef_inode_t *inode, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_INODE_CHANGE_TIME: {
                                idmef_time_t *tmp = NULL;

                                ret = prelude_extract_time_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_inode_set_change_time(inode, tmp);
				break;
			}

			case IDMEF_MSG_INODE_NUMBER: {
                                uint32_t tmp = 0;

                                ret = prelude_extract_uint32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_inode_set_number(inode, tmp);
				break;
			}

			case IDMEF_MSG_INODE_MAJOR_DEVICE: {
                                uint32_t tmp = 0;

                                ret = prelude_extract_uint32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_inode_set_major_device(inode, tmp);
				break;
			}

			case IDMEF_MSG_INODE_MINOR_DEVICE: {
                                uint32_t tmp = 0;

                                ret = prelude_extract_uint32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_inode_set_minor_device(inode, tmp);
				break;
			}

			case IDMEF_MSG_INODE_C_MAJOR_DEVICE: {
                                uint32_t tmp = 0;

                                ret = prelude_extract_uint32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_inode_set_c_major_device(inode, tmp);
				break;
			}

			case IDMEF_MSG_INODE_C_MINOR_DEVICE: {
                                uint32_t tmp = 0;

                                ret = prelude_extract_uint32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_inode_set_c_minor_device(inode, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_inode_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_checksum_read:
 * @checksum: Pointer to a #idmef_checksum_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_checksum from the @msg message, and 
 * store it into @checksum.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_checksum_read(idmef_checksum_t *checksum, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_CHECKSUM_VALUE: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_checksum_set_value(checksum, tmp);
				break;
			}

			case IDMEF_MSG_CHECKSUM_KEY: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_checksum_set_key(checksum, tmp);
				break;
			}

			case IDMEF_MSG_CHECKSUM_ALGORITHM: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_checksum_set_algorithm(checksum, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_checksum_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_file_read:
 * @file: Pointer to a #idmef_file_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_file from the @msg message, and 
 * store it into @file.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_file_read(idmef_file_t *file, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_FILE_IDENT: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_file_set_ident(file, tmp);
				break;
			}

			case IDMEF_MSG_FILE_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_file_set_name(file, tmp);
				break;
			}

			case IDMEF_MSG_FILE_PATH: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_file_set_path(file, tmp);
				break;
			}

			case IDMEF_MSG_FILE_CREATE_TIME: {
                                idmef_time_t *tmp = NULL;

                                ret = prelude_extract_time_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_file_set_create_time(file, tmp);
				break;
			}

			case IDMEF_MSG_FILE_MODIFY_TIME: {
                                idmef_time_t *tmp = NULL;

                                ret = prelude_extract_time_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_file_set_modify_time(file, tmp);
				break;
			}

			case IDMEF_MSG_FILE_ACCESS_TIME: {
                                idmef_time_t *tmp = NULL;

                                ret = prelude_extract_time_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_file_set_access_time(file, tmp);
				break;
			}

			case IDMEF_MSG_FILE_DATA_SIZE: {
                                uint64_t tmp = 0;

                                ret = prelude_extract_uint64_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_file_set_data_size(file, tmp);
				break;
			}

			case IDMEF_MSG_FILE_DISK_SIZE: {
                                uint64_t tmp = 0;

                                ret = prelude_extract_uint64_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_file_set_disk_size(file, tmp);
				break;
			}

			case IDMEF_MSG_FILE_ACCESS_TAG: {
                                int ret;
				idmef_file_access_t *tmp = NULL;

				ret = idmef_file_new_file_access(file, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_file_access_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_LINKAGE_TAG: {
                                int ret;
				idmef_linkage_t *tmp = NULL;

				ret = idmef_file_new_linkage(file, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_linkage_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_INODE_TAG: {
                                int ret;
				idmef_inode_t *tmp = NULL;

				ret = idmef_file_new_inode(file, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_inode_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_CHECKSUM_TAG: {
                                int ret;
				idmef_checksum_t *tmp = NULL;

				ret = idmef_file_new_checksum(file, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_checksum_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_FILE_CATEGORY: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_file_set_category(file, tmp);
				break;
			}

			case IDMEF_MSG_FILE_FSTYPE: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_file_set_fstype(file, tmp);
				break;
			}

			case IDMEF_MSG_FILE_FILE_TYPE: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_file_set_file_type(file, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_file_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_linkage_read:
 * @linkage: Pointer to a #idmef_linkage_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_linkage from the @msg message, and 
 * store it into @linkage.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_linkage_read(idmef_linkage_t *linkage, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_LINKAGE_CATEGORY: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_linkage_set_category(linkage, tmp);
				break;
			}

			case IDMEF_MSG_LINKAGE_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_linkage_set_name(linkage, tmp);
				break;
			}

			case IDMEF_MSG_LINKAGE_PATH: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_linkage_set_path(linkage, tmp);
				break;
			}

			case IDMEF_MSG_FILE_TAG: {
                                int ret;
				idmef_file_t *tmp = NULL;

				ret = idmef_linkage_new_file(linkage, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_file_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_linkage_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_target_read:
 * @target: Pointer to a #idmef_target_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_target from the @msg message, and 
 * store it into @target.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_target_read(idmef_target_t *target, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_TARGET_IDENT: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_target_set_ident(target, tmp);
				break;
			}

			case IDMEF_MSG_TARGET_DECOY: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_target_set_decoy(target, tmp);
				break;
			}

			case IDMEF_MSG_TARGET_INTERFACE: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_target_set_interface(target, tmp);
				break;
			}

			case IDMEF_MSG_NODE_TAG: {
                                int ret;
				idmef_node_t *tmp = NULL;

				ret = idmef_target_new_node(target, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_node_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_USER_TAG: {
                                int ret;
				idmef_user_t *tmp = NULL;

				ret = idmef_target_new_user(target, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_user_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_PROCESS_TAG: {
                                int ret;
				idmef_process_t *tmp = NULL;

				ret = idmef_target_new_process(target, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_process_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_SERVICE_TAG: {
                                int ret;
				idmef_service_t *tmp = NULL;

				ret = idmef_target_new_service(target, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_service_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_FILE_TAG: {
                                int ret;
				idmef_file_t *tmp = NULL;

				ret = idmef_target_new_file(target, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_file_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_target_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_analyzer_read:
 * @analyzer: Pointer to a #idmef_analyzer_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_analyzer from the @msg message, and 
 * store it into @analyzer.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_analyzer_read(idmef_analyzer_t *analyzer, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_ANALYZER_ANALYZERID: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_analyzer_set_analyzerid(analyzer, tmp);
				break;
			}

			case IDMEF_MSG_ANALYZER_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_analyzer_set_name(analyzer, tmp);
				break;
			}

			case IDMEF_MSG_ANALYZER_MANUFACTURER: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_analyzer_set_manufacturer(analyzer, tmp);
				break;
			}

			case IDMEF_MSG_ANALYZER_MODEL: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_analyzer_set_model(analyzer, tmp);
				break;
			}

			case IDMEF_MSG_ANALYZER_VERSION: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_analyzer_set_version(analyzer, tmp);
				break;
			}

			case IDMEF_MSG_ANALYZER_CLASS: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_analyzer_set_class(analyzer, tmp);
				break;
			}

			case IDMEF_MSG_ANALYZER_OSTYPE: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_analyzer_set_ostype(analyzer, tmp);
				break;
			}

			case IDMEF_MSG_ANALYZER_OSVERSION: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_analyzer_set_osversion(analyzer, tmp);
				break;
			}

			case IDMEF_MSG_NODE_TAG: {
                                int ret;
				idmef_node_t *tmp = NULL;

				ret = idmef_analyzer_new_node(analyzer, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_node_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_PROCESS_TAG: {
                                int ret;
				idmef_process_t *tmp = NULL;

				ret = idmef_analyzer_new_process(analyzer, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_process_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_analyzer_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_alertident_read:
 * @alertident: Pointer to a #idmef_alertident_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_alertident from the @msg message, and 
 * store it into @alertident.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_alertident_read(idmef_alertident_t *alertident, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_ALERTIDENT_ALERTIDENT: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_alertident_set_alertident(alertident, tmp);
				break;
			}

			case IDMEF_MSG_ALERTIDENT_ANALYZERID: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_alertident_set_analyzerid(alertident, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_alertident_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_impact_read:
 * @impact: Pointer to a #idmef_impact_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_impact from the @msg message, and 
 * store it into @impact.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_impact_read(idmef_impact_t *impact, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_IMPACT_SEVERITY: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_impact_set_severity(impact, tmp);
				break;
			}

			case IDMEF_MSG_IMPACT_COMPLETION: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_impact_set_completion(impact, tmp);
				break;
			}

			case IDMEF_MSG_IMPACT_TYPE: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_impact_set_type(impact, tmp);
				break;
			}

			case IDMEF_MSG_IMPACT_DESCRIPTION: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_impact_set_description(impact, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_impact_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_action_read:
 * @action: Pointer to a #idmef_action_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_action from the @msg message, and 
 * store it into @action.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_action_read(idmef_action_t *action, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_ACTION_CATEGORY: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_action_set_category(action, tmp);
				break;
			}

			case IDMEF_MSG_ACTION_DESCRIPTION: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_action_set_description(action, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_action_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_confidence_read:
 * @confidence: Pointer to a #idmef_confidence_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_confidence from the @msg message, and 
 * store it into @confidence.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_confidence_read(idmef_confidence_t *confidence, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_CONFIDENCE_RATING: {
                                int32_t tmp = 0;

                                ret = prelude_extract_int32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_confidence_set_rating(confidence, tmp);
				break;
			}

			case IDMEF_MSG_CONFIDENCE_CONFIDENCE: {
                                float tmp = 0;

                                ret = prelude_extract_float_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_confidence_set_confidence(confidence, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_confidence_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_assessment_read:
 * @assessment: Pointer to a #idmef_assessment_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_assessment from the @msg message, and 
 * store it into @assessment.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_assessment_read(idmef_assessment_t *assessment, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_IMPACT_TAG: {
                                int ret;
				idmef_impact_t *tmp = NULL;

				ret = idmef_assessment_new_impact(assessment, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_impact_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_ACTION_TAG: {
                                int ret;
				idmef_action_t *tmp = NULL;

				ret = idmef_assessment_new_action(assessment, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_action_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_CONFIDENCE_TAG: {
                                int ret;
				idmef_confidence_t *tmp = NULL;

				ret = idmef_assessment_new_confidence(assessment, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_confidence_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_assessment_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_tool_alert_read:
 * @tool_alert: Pointer to a #idmef_tool_alert_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_tool_alert from the @msg message, and 
 * store it into @tool_alert.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_tool_alert_read(idmef_tool_alert_t *tool_alert, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_TOOL_ALERT_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_tool_alert_set_name(tool_alert, tmp);
				break;
			}

			case IDMEF_MSG_TOOL_ALERT_COMMAND: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_tool_alert_set_command(tool_alert, tmp);
				break;
			}

			case IDMEF_MSG_ALERTIDENT_TAG: {
                                int ret;
				idmef_alertident_t *tmp = NULL;

				ret = idmef_tool_alert_new_alertident(tool_alert, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_alertident_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_tool_alert_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_correlation_alert_read:
 * @correlation_alert: Pointer to a #idmef_correlation_alert_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_correlation_alert from the @msg message, and 
 * store it into @correlation_alert.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_correlation_alert_read(idmef_correlation_alert_t *correlation_alert, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_CORRELATION_ALERT_NAME: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_correlation_alert_set_name(correlation_alert, tmp);
				break;
			}

			case IDMEF_MSG_ALERTIDENT_TAG: {
                                int ret;
				idmef_alertident_t *tmp = NULL;

				ret = idmef_correlation_alert_new_alertident(correlation_alert, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_alertident_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_correlation_alert_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_overflow_alert_read:
 * @overflow_alert: Pointer to a #idmef_overflow_alert_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_overflow_alert from the @msg message, and 
 * store it into @overflow_alert.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_overflow_alert_read(idmef_overflow_alert_t *overflow_alert, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_OVERFLOW_ALERT_PROGRAM: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_overflow_alert_set_program(overflow_alert, tmp);
				break;
			}

			case IDMEF_MSG_OVERFLOW_ALERT_SIZE: {
                                uint32_t tmp = 0;

                                ret = prelude_extract_uint32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_overflow_alert_set_size(overflow_alert, tmp);
				break;
			}

			case IDMEF_MSG_OVERFLOW_ALERT_BUFFER: {
                                idmef_data_t *tmp = NULL;

                                ret = prelude_extract_data_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_overflow_alert_set_buffer(overflow_alert, tmp);
				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_overflow_alert_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_alert_read:
 * @alert: Pointer to a #idmef_alert_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_alert from the @msg message, and 
 * store it into @alert.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_alert_read(idmef_alert_t *alert, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_ALERT_MESSAGEID: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_alert_set_messageid(alert, tmp);
				break;
			}

			case IDMEF_MSG_ANALYZER_TAG: {
                                int ret;
				idmef_analyzer_t *tmp = NULL;

				ret = idmef_alert_new_analyzer(alert, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_analyzer_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_ALERT_CREATE_TIME: {
                                idmef_time_t *tmp = NULL;

                                ret = prelude_extract_time_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_alert_set_create_time(alert, tmp);
				break;
			}

			case IDMEF_MSG_CLASSIFICATION_TAG: {
                                int ret;
				idmef_classification_t *tmp = NULL;

				ret = idmef_alert_new_classification(alert, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_classification_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_ALERT_DETECT_TIME: {
                                idmef_time_t *tmp = NULL;

                                ret = prelude_extract_time_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_alert_set_detect_time(alert, tmp);
				break;
			}

			case IDMEF_MSG_ALERT_ANALYZER_TIME: {
                                idmef_time_t *tmp = NULL;

                                ret = prelude_extract_time_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_alert_set_analyzer_time(alert, tmp);
				break;
			}

			case IDMEF_MSG_SOURCE_TAG: {
                                int ret;
				idmef_source_t *tmp = NULL;

				ret = idmef_alert_new_source(alert, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_source_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_TARGET_TAG: {
                                int ret;
				idmef_target_t *tmp = NULL;

				ret = idmef_alert_new_target(alert, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_target_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_ASSESSMENT_TAG: {
                                int ret;
				idmef_assessment_t *tmp = NULL;

				ret = idmef_alert_new_assessment(alert, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_assessment_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_ADDITIONAL_DATA_TAG: {
                                int ret;
				idmef_additional_data_t *tmp = NULL;

				ret = idmef_alert_new_additional_data(alert, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_additional_data_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_TOOL_ALERT_TAG: {
                                int ret;
				idmef_tool_alert_t *tmp = NULL;

				ret = idmef_alert_new_tool_alert(alert, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_tool_alert_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_CORRELATION_ALERT_TAG: {
                                int ret;
				idmef_correlation_alert_t *tmp = NULL;

				ret = idmef_alert_new_correlation_alert(alert, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_correlation_alert_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_OVERFLOW_ALERT_TAG: {
                                int ret;
				idmef_overflow_alert_t *tmp = NULL;

				ret = idmef_alert_new_overflow_alert(alert, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_overflow_alert_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_alert_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_heartbeat_read:
 * @heartbeat: Pointer to a #idmef_heartbeat_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_heartbeat from the @msg message, and 
 * store it into @heartbeat.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_heartbeat_read(idmef_heartbeat_t *heartbeat, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_HEARTBEAT_MESSAGEID: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_heartbeat_set_messageid(heartbeat, tmp);
				break;
			}

			case IDMEF_MSG_ANALYZER_TAG: {
                                int ret;
				idmef_analyzer_t *tmp = NULL;

				ret = idmef_heartbeat_new_analyzer(heartbeat, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_analyzer_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_HEARTBEAT_CREATE_TIME: {
                                idmef_time_t *tmp = NULL;

                                ret = prelude_extract_time_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_heartbeat_set_create_time(heartbeat, tmp);
				break;
			}

			case IDMEF_MSG_HEARTBEAT_ANALYZER_TIME: {
                                idmef_time_t *tmp = NULL;

                                ret = prelude_extract_time_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_heartbeat_set_analyzer_time(heartbeat, tmp);
				break;
			}

			case IDMEF_MSG_HEARTBEAT_HEARTBEAT_INTERVAL: {
                                uint32_t tmp = 0;

                                ret = prelude_extract_uint32_safe(&tmp, buf, len);
                                if ( ret < 0 )
                                        return ret;

				idmef_heartbeat_set_heartbeat_interval(heartbeat, tmp);
				break;
			}

			case IDMEF_MSG_ADDITIONAL_DATA_TAG: {
                                int ret;
				idmef_additional_data_t *tmp = NULL;

				ret = idmef_heartbeat_new_additional_data(heartbeat, &tmp, -1);
				if ( ret < 0 )
					return ret;



                                ret = idmef_additional_data_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_heartbeat_t: '%u'", tag);
		}

	}

	return 0;
}

/**
 * idmef_message_read:
 * @message: Pointer to a #idmef_message_t object.
 * @msg: Pointer to a #prelude_msg_t object, containing a message.
 *
 * Read an idmef_message from the @msg message, and 
 * store it into @message.
 *
 * Returns: 0 on success, a negative value if an error occured.
 */
int idmef_message_read(idmef_message_t *message, prelude_msg_t *msg)
{
        int ret;
	void *buf;
	uint8_t tag;
	uint32_t len;

	while ( 1 ) {
                ret = prelude_msg_get(msg, &tag, &len, &buf);
                if ( ret < 0 )
		        return ret;

		switch ( tag ) {

			case IDMEF_MSG_MESSAGE_VERSION: {
                                prelude_string_t *tmp = NULL;

                                ret = prelude_extract_string_safe(&tmp, buf, len, msg);
                                if ( ret < 0 )
                                        return ret;

				idmef_message_set_version(message, tmp);
				break;
			}

			case IDMEF_MSG_ALERT_TAG: {
                                int ret;
				idmef_alert_t *tmp = NULL;

				ret = idmef_message_new_alert(message, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_alert_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_HEARTBEAT_TAG: {
                                int ret;
				idmef_heartbeat_t *tmp = NULL;

				ret = idmef_message_new_heartbeat(message, &tmp);
				if ( ret < 0 )
					return ret;



                                ret = idmef_heartbeat_read(tmp, msg);
				if ( ret < 0 )
					return ret;

				break;
			}

			case IDMEF_MSG_END_OF_TAG:
				return 0;

			default:
				return prelude_error_verbose(PRELUDE_ERROR_IDMEF_UNKNOWN_TAG, "Unknown tag while reading idmef_message_t: '%u'", tag);
		}

	}

	return 0;
}
