/*

Copyright (C) 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/resource.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>

#include <libnd_demux_progress.h>

static int prog_total;
static int prog_now;
static const char *prog_file;
static LND_Demux *prog_dm;

void 
demux_prog_init(int num_total)
{
  prog_total = num_total;  
  printf("%s: ", prog_file);
}

void
demux_prog_show(int num_prog)
{
  char output[256];
  int i, len;

  prog_now += num_prog;
  g_snprintf(output, 256, "%i/%i, %u flows", prog_now, prog_total,
	     (prog_dm ? libnd_conn_table_size(prog_dm->conns) : 0));
  len = strlen(output);

  printf("%s", output);
  for (i = 0; i < len; i++)
    printf("\b");
  fflush(stdout);  
}

void
demux_prog_clear(void)
{
  printf("\n");
  prog_now = 0;
  prog_total = 0;
  prog_file = 0;
}


void
libnd_demux_prog_set_file(const char *filename)
{
  prog_file = filename;
}


void
libnd_demux_prog_observer_add(LND_Demux *dm)
{
  LND_PacketIteratorObserver *ob;
  
  prog_dm = dm;

  if ( (ob = libnd_pit_observer_new()))
    {
      ob->pit_init = demux_prog_init;
      ob->pit_progress = demux_prog_show;
      ob->pit_clear = demux_prog_clear;
      libnd_pit_add_observer(ob);
    }
}
