# This spec file creates one relocatable RPM, containing
# both the library files and any headers to install. It's
# likely package bloat to use separate RPMs for such a small
# number of files ...
%define prefix		/usr
%define version		0.8

Summary: Connection State Tracker plugin for libnetdude
Name: libnetdude-conntrack-plugin
Version: %{version}
Release: 1
License: BSD
Group: Applications/Communications
URL: http://netdude.sf.net
# Using FTP to get around SourceForge's habit of adding something after .tar.gz
Source: ftp://ftp.sf.net/pub/sourceforge/netdude/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Packager: Christian Kreibich <christian@whoop.org>
Requires: libnetdude >= 0.7

Prefix: %{prefix}

%description
This plugin implements control blocks for connections running over IP.
The semantics of "connection" depend on the transport protocol: the
plugin models TCP connection endpoints using a TCP connection
state machine, UDP and other protocols are supported by a timeout mechanism.
The plugin provides connection tables to store and retrieve connections
conveniently.

%prep
%setup -q
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=$RPM_BUILD_ROOT%prefix --with-prefix-subst
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=$RPM_BUILD_ROOT%prefix --with-prefix-subst
fi

%build
if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%{prefix}/include/libnetdude/*
%{prefix}/share/libnetdude/*

%changelog
* Wed Dec 28 2005 Christian Kreibich <christian@whoop.org> 
- 0.7.

* Thu May 26 2004 Christian Kreibich <christian@whoop.org> 
- Update to 0.5, with libnetdude 0.7 as minimum requirement.

* Fri Apr 30 2004 Christian Kreibich <christian@whoop.org> 
- Update to 0.4.

* Sat Apr 17 2004 Christian Kreibich <christian@whoop.org> 
- Updated description.

* Mon Apr 05 2004 Christian Kreibich <christian@whoop.org> 
- Update to new conntrack plugin.

* Wed Jan 28 2004 Christian Kreibich <christian@whoop.org> 
- Initial build.
