/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#include <libnd.h>

struct lnd_registry 
{
  char       *name;
  GHashTable *reg;
};

LND_Registry *
libnd_reg_new(const char *name)
{
  LND_Registry *reg = g_new0(LND_Registry, 1);
  
  if (!reg)
    return NULL;

  if (name)
    reg->name = g_strdup(name);
  reg->reg = g_hash_table_new(g_str_hash, g_str_equal);

  return reg;
}


static void
reg_cleanup_cb(gpointer key, gpointer val, gpointer user_data)
{
  /* We strdup()ed the key string thus need to release it.
   * The value was associated externally and we're not responsible for it.
   */
  g_free(key);

  return;
  TOUCH(val);
  TOUCH(user_data);
}

void
libnd_reg_free(LND_Registry *reg)
{
  if (!reg)
    return;

  g_hash_table_foreach(reg->reg, reg_cleanup_cb, NULL);
  g_hash_table_destroy(reg->reg);
  
  g_free(reg->name);
  g_free(reg);
}


void         
libnd_reg_set_data(LND_Registry *reg, const char *key, void *data)
{
  char *key_dup;

  if (!reg || !key)
    return;

  key_dup = g_strdup(key);

  g_hash_table_insert(reg->reg, key_dup, data);
}


void   *
libnd_reg_get_data(const LND_Registry *reg, const char *key)
{
  if (!reg)
    return NULL;

  return g_hash_table_lookup(reg->reg, key);
}


void *    
libnd_reg_del_data(LND_Registry *reg, const char *key)
{
  void       *result;

  if ( (result = g_hash_table_lookup(reg->reg, key)))
    {
      D(("Data item for key '%s' found in reg\n", key));
      g_hash_table_remove(reg->reg, key);
    }
  
  return result;
}


void
libnd_reg_foreach(const LND_Registry *reg, LND_RegCB callback, void *user_data)
{
  if (!reg || !callback)
    return;

  g_hash_table_foreach(reg->reg, (GHFunc) callback, user_data);
}
