/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libnd.h>
#include <libnd_debug.h>
#include <libnd_protocol_inst.h>
#include <libnd_protocol.h>

void
libnd_proto_inst_init(LND_ProtoInst *pi,
		      LND_Protocol *proto,
		      guint nesting)
{
  if (!pi)
    return;

  memset(pi, 0, sizeof(LND_ProtoInst));
  pi->proto = proto;
  pi->nesting = nesting;
}


const char       *
libnd_proto_inst_to_string(const LND_Protocol *proto, guint nesting)
{
  static char s[MAXPATHLEN];

  if (!proto)
    return NULL;

  g_snprintf(s, MAXPATHLEN, "%s_%u", proto->name, nesting);
  return s;
}


LND_ProtoData     *
libnd_proto_data_new(LND_Protocol *protocol, guint nesting, guchar *data, guchar *data_end)
{
  LND_ProtoData *pd;

  pd = g_new0(LND_ProtoData, 1);
  D_ASSERT_PTR(pd);
  if (!pd)
    return NULL;

  if (data_end < data)
    {
      D(("Assertion failed -- data end smaller than data start!\n"));
      return NULL;
    }

  libnd_proto_inst_init(&pd->inst, protocol, nesting);
  pd->data = data;
  pd->data_end = data_end;

  return pd;
}


void              
libnd_proto_data_free(LND_ProtoData *pd)
{
  g_free(pd);
}


LND_ProtoInfo     *
libnd_proto_info_new(LND_Protocol *proto, guint nesting)
{
  LND_ProtoInfo *pinf;

  pinf = g_new0(LND_ProtoInfo, 1);
  D_ASSERT_PTR(pinf);
  if (!pinf)
    return NULL;

  D(("Creating proto info for %s/%i\n", proto->name, nesting));
  
  libnd_proto_inst_init(&pinf->inst, proto, nesting);
  pinf->registry = libnd_reg_new("proto_inst_data");

  return pinf;
}


void              
libnd_proto_info_free(LND_ProtoInfo *pinf)
{
  D(("Cleaning up LND_ProtoInfo\n"));
  libnd_reg_free(pinf->registry);
  g_free(pinf);
}
