/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libnd_debug.h>
#include <libnd_globals.h>
#include <libnd_packet_iterator.h>
#include <libnd_null_protocol.h>
#include <libnd_protocol_inst.h>
#include <libnd_protocol.h>


LND_Protocol   *
libnd_proto_new(const char *name, LND_ProtocolLayer layer, guint64 magic)
{
  static gint64 id = 1;
  LND_Protocol *proto;

  proto= (LND_Protocol*) g_new0(LND_Protocol, 1);
  D_ASSERT_PTR(proto);
  if (!proto)
    return NULL;

  /* Hook in null ops for segfault protection and cleaner code: */
  libnd_null_proto_hook_up(proto);

  proto->name     = g_strdup(name);
  proto->layer    = layer;
  proto->magic[0] = magic;
  proto->id       = id;

  /* Create the protocol data registry: */
  proto->registry = libnd_reg_new("proto_user_data");
  
  id *= 2;

  return proto;
}


void
libnd_proto_free(LND_Protocol *proto)
{
  if (!proto)
    return;

  libnd_reg_free(proto->registry);
  
  /* The protocol struct is initialized as a
     static structure, so most items don't need
     to be freed ... */

  g_free(proto);
}


gboolean           
libnd_proto_is_raw(LND_Protocol *proto)
{
  if (!proto)
    return FALSE;

  if (proto->id == 1)
    return TRUE;

  return FALSE;
}


const char        *
libnd_proto_layer_to_string(LND_ProtocolLayer layer)
{
  static char s[512];

  switch (layer)
    {
    case LND_PROTO_LAYER_LINK:
      g_snprintf(s, 512, "link layer");
      break;

    case LND_PROTO_LAYER_NET:
      g_snprintf(s, 512, "network layer");
      break;

    case LND_PROTO_LAYER_TRANS:
      g_snprintf(s, 512, "transport layer");
      break;

    case LND_PROTO_LAYER_APP:
    default:
      g_snprintf(s, 512, "application layer");
      break;
    }

  return s;
}
