/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __libnd_ether_h
#define __libnd_ether_h

#include <libnd.h>

#include <net/if.h>
#include <netinet/if_ether.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* These are the implementations for Ethernet of LND_Protocol's callbacks: */
void         libnd_ether_init_packet(LND_Packet *packet, guchar *data, guchar *data_end);
gboolean     libnd_ether_header_complete(const LND_Packet *packet, guint nesting);

/* Generic accessor function for the Ethernet Protocol implementation: */
LND_Protocol *libnd_ether_get(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
