/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __libnd_802_11_h
#define __libnd_802_11_h

#include <libnd.h>

#include <net/if.h>
#include <netinet/if_ether.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define LND_802_11_LEN 24


struct lnd_802_11_header {

  struct {
    guchar      version   : 2;
    guchar      type      : 2;
    guchar      subtype   : 4;
    guchar      to_ds     : 1;
    guchar      from_ds   : 1;
    guchar      more_frag : 1;
    guchar      retry     : 1;
    guchar      pw_mgmt   : 1;
    guchar      more_data : 1;
    guchar      wep       : 1;
    guchar      order     : 1;
  } ctrl;

  guint16	duration;
  guchar	mac1[6];
  guchar	mac2[6];
  guchar	mac3[6];
  guint16	seq_ctrl;
};

/* These are the implementations for 802.11 of LND_Protocol's callbacks: */
void          libnd_802_11_init_packet(LND_Packet *packet, guchar *data, guchar *data_end);
gboolean      libnd_802_11_header_complete(const LND_Packet *packet, guint nesting);

/* Generic accessor function for the 802.11 protocol implementation: */
LND_Protocol *libnd_802_11_get(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
