/* $Id: cpuinfo.c,v 1.3 2002/10/25 05:43:09 skids Exp $
******************************************************************************

   cpuinfo - Prints out the type of SWAR's CPU's supports.

   Copyright (C) 2002 Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/


/* TODO:
 *
 * - Loop over number of CPU's once SWAR supports that.
 */


#include <stdio.h>
#include <ggi/gg.h>

int main(void)
{
	enum gg_swartype swar;

	swar = ggGetSwarType();


	printf("This CPU has the following SWAR's:\n");

	if (swar & GG_SWAR_NONE) {
		printf("- Vanilla C implementation\n");
	}	/* if */

	if (swar & GG_SWAR_32BITC) {
		printf("- Fast 32b math vs 16b\n");
	}	/* if */

	if (swar & GG_SWAR_ALTIVEC) {
		printf("- PowerPC G4 Altivec\n");
	}	/* if */

	if (swar & GG_SWAR_SSE) {
		printf("- x86 SSE\n");
	}	/* if */

	if (swar & GG_SWAR_SSE2) {
		printf("- x86 SSE2\n");
	}	/* if */

	if (swar & GG_SWAR_MMX) {
		printf("- x86 MMX\n");
	}	/* if */

	if (swar & GG_SWAR_MMXPLUS) {
		printf("- Cyrix MMX plus\n");
	}	/* if */

	if (swar & GG_SWAR_3DNOW) {
		printf("- AMD 3DNow!\n");
	}	/* if */

	if (swar & GG_SWAR_ADV3DNOW) {
		printf("- AMD 3DNow! advanced\n");
	}	/* if */

	if (swar & GG_SWAR_MAX) {
		printf("- SWAR MAX\n");
	}	/* if */

	if (swar & GG_SWAR_SIGD) {
		printf("- SWAR SIGD\n");
	}	/* if */

#ifdef GG_HAVE_INT64

	if (swar & GG_SWAR_64BITC) {
		printf("- Fast 64b math vs 32b\n");
	}	/* if */

	if (swar & GG_SWAR_MVI) {
		printf("- SWAR MVI\n");
	}	/* if */

	if (swar & GG_SWAR_MAX2) {
		printf("- SWAR MAX2\n");
	}	/* if */

	if (swar & GG_SWAR_MDMX) {
		printf("- SWAR MDMX\n");
	}	/* if */

	if (swar & GG_SWAR_MAJC) {
		printf("- SWAR MAJC\n");
	}	/* if */

	if (swar & GG_SWAR_VIS) {
		printf("- Sparc VIS\n");
	}	/* if */

#endif

	return 0;
}	/* main */
