/* $Id: key2event.c,v 1.1 2000/12/17 23:19:36 marcus Exp $
******************************************************************************

   FreeBSD vgl(3) inputlib key to event converter

   Copyright (C) 2000 Alcove - Nicolas Souchu <nsouch@freebsd.org>

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "input-vgl.h"
#include "keycodes.h"

gii_event_mask
GII_vgl_key2event(struct gii_input *inp, int keycode)
{
	gii_vgl_priv *priv = VGL_PRIV(inp);
	gii_event ev;
	uint32 label = GIIK_NIL;
	int ret;

	_giiEventBlank(&ev, sizeof(gii_key_event));

	if (keycode & 0x80) {
		ev.any.type = evKeyRelease;
		ret = emKeyRelease;
	} else {
		if (priv->prev_keycode == keycode) {
			ev.any.type = evKeyRepeat;
			ret = emKeyRepeat;
		} else {
			ev.any.type = evKeyPress;
			ret = emKeyPress;
		}
	}

	ev.any.size = sizeof(gii_key_event);
	ev.any.origin = inp->origin;

	ev.key.modifiers = 0;
	ev.key.button = keycode;

	switch (keycode) {
	case KEY_NOKEY:
		label = GIIK_NIL;
		break;
	case KEY_ESC:
		label = GIIUC_Escape;
		break;
	case KEY_1:
		label = GIIUC_1;
		break;
	case KEY_2:
		label = GIIUC_2;
		break;
	case KEY_3:
		label = GIIUC_3;
		break;
	case KEY_4:
		label = GIIUC_4;
		break;
	case KEY_5:
		label = GIIUC_5;
		break;
	case KEY_6:
		label = GIIUC_6;
		break;
	case KEY_7:
		label = GIIUC_7;
		break;
	case KEY_8:
		label = GIIUC_8;
		break;
	case KEY_9:
		label = GIIUC_9;
		break;
	case KEY_0:
		label = GIIUC_0;
		break;
	case KEY_MINUS:
		label = GIIUC_Minus;
		break;
	case KEY_EQUAL:
		label = GIIUC_Equal;
		break;
	case KEY_BACKSPACE:
		label = GIIUC_BackSpace;
		break;
	case KEY_TAB:
		label = GIIUC_Tab;
		break;
	case KEY_Q:
		label = GIIUC_Q;
		break;
	case KEY_W:
		label = GIIUC_W;
		break;
	case KEY_E:
		label = GIIUC_E;
		break;
	case KEY_R:
		label = GIIUC_R;
		break;
	case KEY_T:
		label = GIIUC_T;
		break;
	case KEY_Y:
		label = GIIUC_Y;
		break;
	case KEY_U:
		label = GIIUC_U;
		break;
	case KEY_I:
		label = GIIUC_I;
		break;
	case KEY_O:
		label = GIIUC_O;
		break;
	case KEY_P:
		label = GIIUC_P;
		break;
	case KEY_LEFTBRACE:
		label = GIIUC_BraceLeft;
		break;
	case KEY_RIGHTBRACE:
		label = GIIUC_BraceRight;
		break;
	case KEY_ENTER:
		label = GIIK_Enter;
		break;
	case KEY_LEFTCTRL:
		label = GIIK_CtrlL;
		break;
	case KEY_A:
		label = GIIUC_A;
		break;
	case KEY_S:
		label = GIIUC_S;
		break;
	case KEY_D:
		label = GIIUC_D;
		break;
	case KEY_F:
		label = GIIUC_F;
		break;
	case KEY_G:
		label = GIIUC_G;
		break;
	case KEY_H:
		label = GIIUC_H;
		break;
	case KEY_J:
		label = GIIUC_J;
		break;
	case KEY_K:
		label = GIIUC_K;
		break;
	case KEY_L:
		label = GIIUC_L;
		break;
	case KEY_SEMICOLON:
		label = GIIUC_Semicolon;
		break;
	case KEY_APOSTROPHE:
		label = GIIUC_Apostrophe;
		break;
	case KEY_GRAVE:
		label = GIIUC_Grave;
		break;
	case KEY_LEFTSHIFT:
		label = GIIK_ShiftL;
		break;
	case KEY_BACKSLASH:
		label = GIIUC_BackSlash;
		break;
	case KEY_Z:
		label = GIIUC_Z;
		break;
	case KEY_X:
		label = GIIUC_X;
		break;
	case KEY_C:
		label = GIIUC_C;
		break;
	case KEY_V:
		label = GIIUC_V;
		break;
	case KEY_B:
		label = GIIUC_B;
		break;
	case KEY_N:
		label = GIIUC_N;
		break;
	case KEY_M:
		label = GIIUC_M;
		break;
	case KEY_COMMA:
		label = GIIUC_Comma;
		break;
	case KEY_DOT:
		label = GIIUC_Period;
		break;
	case KEY_SLASH:
		label = GIIUC_Slash;
		break;
	case KEY_RIGHTSHIFT:
		label = GIIK_ShiftR;
		break;
	case KEY_KPASTERISK:
		label = GIIK_PAsterisk;
		break;
	case KEY_LEFTALT:
		label = GIIK_AltL;
		break;
	case KEY_SPACE:
		label = GIIUC_Space;
		break;
	case KEY_CAPSLOCK:
		label = GIIK_CapsLock;
		break;
	case KEY_F1:
		label = GIIK_F1;
		break;
	case KEY_F2:
		label = GIIK_F2;
		break;
	case KEY_F3:
		label = GIIK_F3;
		break;
	case KEY_F4:
		label = GIIK_F4;
		break;
	case KEY_F5:
		label = GIIK_F5;
		break;
	case KEY_F6:
		label = GIIK_F6;
		break;
	case KEY_F7:
		label = GIIK_F7;
		break;
	case KEY_F8:
		label = GIIK_F8;
		break;
	case KEY_F9:
		label = GIIK_F9;
		break;
	case KEY_F10:
		label = GIIK_F10;
		break;
	case KEY_NUMLOCK:
		label = GIIK_NumLock;
		break;
	case KEY_SCROLLLOCK:
		label = GIIK_ScrollLock;
		break;
	case KEY_KP7:
		label = GIIK_P7;
		break;
	case KEY_KP8:
		label = GIIK_P8;
		break;
	case KEY_KP9:
		label = GIIK_P9;
		break;
	case KEY_KPMINUS:
		label = GIIK_PMinus;
		break;
	case KEY_KP4:
		label = GIIK_P4;
		break;
	case KEY_KP5:
		label = GIIK_P5;
		break;
	case KEY_KP6:
		label = GIIK_P6;
		break;
	case KEY_KPPLUS:
		label = GIIK_PPlus;
		break;
	case KEY_KP1:
		label = GIIK_P1;
		break;
	case KEY_KP2:
		label = GIIK_P2;
		break;
	case KEY_KP3:
		label = GIIK_P3;
		break;
	case KEY_KP0:
		label = GIIK_P0;
		break;
	case KEY_KPDOT:
		label = GIIK_PDecimal;
		break;
#if 0
	case KEY_102ND:
		label = GIIK_102ND;
		break;
#endif
	case KEY_F11:
		label = GIIK_F11;
		break;
	case KEY_F12:
		label = GIIK_F12;
		break;
	case KEY_KPENTER:
		label = GIIK_PEnter;
		break;
	case KEY_RIGHTCTRL:
		label = GIIK_CtrlR;
		break;
	case KEY_KPSLASH:
		label = GIIK_PSlash;
		break;
	case KEY_SYSRQ:
		label = GIIK_SysRq;
		break;
	case KEY_RIGHTALT:
		label = GIIK_AltR;
		break;
	case KEY_HOME:
		label = GIIK_Home;
		break;
	case KEY_UP:
		label = GIIK_Up;
		break;
	case KEY_PAGEUP:
		label = GIIK_PageUp;
		break;
	case KEY_LEFT:
		label = GIIK_Left;
		break;
	case KEY_RIGHT:
		label = GIIK_Right;
		break;
	case KEY_END:
		label = GIIK_End;
		break;
	case KEY_DOWN:
		label = GIIK_Down;
		break;
	case KEY_PAGEDOWN:
		label = GIIK_PageDown;
		break;
	case KEY_INSERT:
		label = GIIK_Insert;
		break;
	case KEY_DELETE:
		label = GIIK_Delete;
		break;
	case KEY_PAUSE:
		label = GIIK_Pause;
		break;
	case KEY_LEFTMETA:
		label = GIIK_MetaL;
		break;
	case KEY_RIGHTMETA:
		label = GIIK_MetaR;
		break;
	case KEY_COMPOSE:
		/* This is actually the Windows Menu key on PC-keyobards... */
		label = GIIK_Compose;
		break;
	default:
		GIIDPRINT_EVENTS("GII_vgl_key2event: Unknown keycode 0x%x.\n",
				 keycode);
		return 0;
		break;
	}

	/* Keyboard key. */
	ev.key.label = label;
	ev.key.sym = ev.key.label;

	_giiEvQueueAdd(inp, &ev);
	
	return ret;
}
