/* $Id: input.c,v 1.1 2000/07/09 23:41:05 marcus Exp $
******************************************************************************

   Linux evdev inputlib

   Copyright (C) 2000 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "linux_evdev.h"
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>

#define SKIPWHITE(str)	while (isspace((int)*(str))) (str)++

static gii_cmddata_getdevinfo devinfo =
{
	"Linux Evdev",	/* long device name */
	"edev",		/* shorthand */
	emAll,		/* can_generate */
	GII_NUM_UNKNOWN,/* num_buttons */
	GII_NUM_UNKNOWN,/* num_axes */
};

static gii_deviceinfo xdevinfo =
{
	NULL,
	0,
	&devinfo,
	NULL
};

static void send_devinfo(gii_input *inp)
{
	gii_event ev;
	gii_cmddata_getdevinfo *dinfo;
	int size = sizeof(gii_cmd_nodata_event)+sizeof(gii_cmddata_getdevinfo);

	_giiEventBlank(&ev, size);
	
	ev.any.size   = size;
	ev.any.type   = evCommand;
	ev.any.origin = inp->origin;
	ev.cmd.code   = GII_CMDCODE_GETDEVINFO;

	dinfo = (gii_cmddata_getdevinfo *) &ev.cmd.data;
	*dinfo = devinfo;

	_giiEvQueueAdd(inp, &ev);
}


static int
GIIsendevent(gii_input *inp, gii_event *ev)
{
	if (ev->any.target != inp->origin &&
	    ev->any.target != GII_EV_TARGET_ALL) {
		/* not for us */
		return GGI_EEVNOTARGET;
	}

	if (ev->any.type != evCommand) {
		return GGI_EEVUNKNOWN;
	}

	if (ev->cmd.code == GII_CMDCODE_GETDEVINFO) {
		send_devinfo(inp);
		return 0;
	}

	return GGI_EEVUNKNOWN;	/* Unknown command */
}


static int
GIIclose(struct gii_input *inp)
{
	gii_levdev_priv *priv = inp->priv;

	if (priv->fd) close(priv->fd);
	free(priv);

	return 0;
}


int GIIdlinit(gii_input *inp, const char *args, void *argptr)
{
	const char *devname = "/dev/input/event0";
	gii_levdev_priv *priv;
	int fd;
	
	GIIDPRINT_LIBS("Linux evdev starting.\n");

	if (args && *args) {
		devname = args;
	}

	fd = open(devname, O_RDONLY);
	if (fd < 0) return GGI_ENODEVICE;

	priv = malloc(sizeof(*priv));
	if (priv == NULL) {
		close(fd);
		return GGI_ENOMEM;
	}

	inp->GIIsendevent = GIIsendevent;
	inp->GIIeventpoll = GII_levdev_poll;
	inp->GIIclose = GIIclose;
	inp->devinfo    = &xdevinfo;
	xdevinfo.origin = inp->origin;

	inp->targetcan = emAll;
	inp->curreventmask = emAll;

	inp->maxfd = fd + 1;
	FD_SET(fd, &inp->fdset);

	priv->fd = fd;
	priv->eof = 0;

	inp->priv = priv;

	send_devinfo(inp);

	GIIDPRINT_LIBS("Linux evdev up.\n");

	return 0;
}
