/* $Id: dxinput.h,v 1.1 2000/01/20 23:15:03 marcus Exp $
******************************************************************************

   DirectX inputlib internal header

   Copyright (C) 1999-2000 John Fortin		[fortinj@ibm.net]
   Copyright (C) 2000      Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>
#include <windows.h>

#define DIRECTINPUT_VERSION         0x0300
#include <dinput.h>

#include <ggi/internal/gii-dl.h>


#define WM_DDMESSAGEBOX         0x7FFF

#define GII_DX_BUFFER_SIZE 1024	/* number of buffer elements */

typedef struct {
	HWND			hWnd;
	IDirectInput		*pDI;
	IDirectInputDevice	*pKeyboard;
	IDirectInputDevice	*pMouse;
	uint32			modifiers;
} gii_di_priv;


HRESULT _gii_dx_InitDirectInput(gii_di_priv *priv, HWND hDlg,
				HINSTANCE hInstance);
HRESULT _gii_dx_SetAcquire(gii_di_priv *priv);
HRESULT _gii_dx_FreeDirectInput(gii_di_priv *priv);
HRESULT _gii_dx_GetKBInput(gii_di_priv *priv, DWORD * dwElements,
			   char *kb_buffer);
HRESULT _gii_dx_GetPtrInput(gii_di_priv *priv, DWORD * dwElements,
			    char *kb_buffer);
HRESULT _gii_dx_DDMessageBox(HWND hWnd, LPCTSTR text, LPCTSTR caption);

#define DI_PRIV(inp)  ((gii_di_priv *)(inp)->priv)
