/* $Id: di.c,v 1.1 2000/01/20 23:15:03 marcus Exp $
******************************************************************************

   DirectX inputlib

   Copyright (C) 1999-2000 John Fortin		[fortinj@ibm.net]
   Copyright (C) 2000      Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <dxinput.h>


HRESULT
_gii_dx_InitDirectInput(gii_di_priv *priv, HWND hWnd, HINSTANCE hInstance)
{
	HRESULT hr;
	DIPROPDWORD dipdw_k;
	DIPROPDWORD dipdw_m;

	hr = DirectInputCreate(hInstance, 0x0300, &priv->pDI, NULL);
	if (FAILED(hr))	return hr;

	hr = priv->pDI->lpVtbl->CreateDevice(priv->pDI, &GUID_SysKeyboard,
					     &priv->pKeyboard, NULL);
	if (FAILED(hr))	return hr;

	hr = IDirectInputDevice_SetDataFormat(priv->pKeyboard,
					      &c_dfDIKeyboard);
	if (FAILED(hr))	return hr;

	hr = IDirectInputDevice_SetCooperativeLevel(priv->pKeyboard, hWnd,
				  DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
	if (FAILED(hr))	return hr;

	dipdw_k.diph.dwSize = sizeof(DIPROPDWORD);
	dipdw_k.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	dipdw_k.diph.dwObj = 0;
	dipdw_k.diph.dwHow = DIPH_DEVICE;
	dipdw_k.dwData = GII_DX_BUFFER_SIZE;

	hr = IDirectInputDevice_SetProperty(priv->pKeyboard, DIPROP_BUFFERSIZE,
					    &dipdw_k.diph);

	hr = priv->pDI->lpVtbl->CreateDevice(priv->pDI, &GUID_SysMouse,
					     &priv->pMouse, NULL);
	if (FAILED(hr)) {
		return hr;
	}
	hr = IDirectInputDevice_SetDataFormat(priv->pMouse, &c_dfDIMouse);
	if (FAILED(hr)) {
		return hr;
	}
	hr = IDirectInputDevice_SetCooperativeLevel(priv->pMouse, hWnd,
				  DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
	if (FAILED(hr)) {
		return hr;
	}
	dipdw_m.diph.dwSize = sizeof(DIPROPDWORD);
	dipdw_m.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	dipdw_m.diph.dwObj = 0;
	dipdw_m.diph.dwHow = DIPH_DEVICE;
	dipdw_m.dwData = GII_DX_BUFFER_SIZE;

	hr = IDirectInputDevice_SetProperty(priv->pMouse, DIPROP_BUFFERSIZE,
					    &dipdw_m.diph);

	return S_OK;
}


HRESULT
_gii_dx_SetAcquire(gii_di_priv *priv)
{
	if (NULL == priv->pKeyboard) return S_FALSE;

	IDirectInputDevice_Acquire(priv->pKeyboard);
	IDirectInputDevice_Acquire(priv->pMouse);

	return S_OK;
}


HRESULT
_gii_dx_GetKBInput(gii_di_priv *priv, DWORD *dwElements, char *kb_buff)
{
	DWORD i, hr;
	DIDEVICEOBJECTDATA didod[GII_DX_BUFFER_SIZE];

	if (NULL != priv->pKeyboard) {
		hr = DIERR_INPUTLOST;

		while (hr != DI_OK) {

			*dwElements = GII_DX_BUFFER_SIZE;
			hr = IDirectInputDevice_GetDeviceData(priv->pKeyboard,
					sizeof(DIDEVICEOBJECTDATA),
					didod, dwElements, 0);
			if (hr != DI_OK) {
				hr = IDirectInputDevice_Acquire(priv->pKeyboard);
				hr = DIERR_INPUTLOST;
				if (FAILED(hr)) {
					*dwElements = 0;
					return hr;
				}
			}
		}

		for (i = 0; i < *dwElements; i++) {
			kb_buff[2 * i] = didod[i].dwOfs;
			kb_buff[2 * i + 1]
				= (didod[i].dwData & 0x80) ? 'D' : 'U';
		}
		kb_buff[2 * i] = 0;	/* Terminate the string */

	}
	return S_OK;
}


HRESULT
_gii_dx_GetPtrInput(gii_di_priv *priv, DWORD *dwElements, char *ptr_buff)
{
	DWORD i, hr;
	DIDEVICEOBJECTDATA didod[GII_DX_BUFFER_SIZE];

	if (NULL != priv->pMouse) {
		hr = DIERR_INPUTLOST;

		while (hr != DI_OK) {

			*dwElements = GII_DX_BUFFER_SIZE;
			hr = IDirectInputDevice_GetDeviceData(priv->pMouse,
						sizeof(DIDEVICEOBJECTDATA),
						didod, dwElements, 0);
			if (hr != DI_OK) {
				hr = IDirectInputDevice_Acquire(priv->pMouse);
				if (FAILED(hr)) {
					*dwElements = 0;
					return hr;
				}
			}
		}

		for (i = 0; i < *dwElements; i++) {
			ptr_buff[2 * i] = didod[i].dwOfs;
			ptr_buff[2 * i + 1] = didod[i].dwData;
		}
		ptr_buff[2 * i] = 0;	/* Terminate the string */

	}

	return 0;
}


HRESULT
_gii_dx_FreeDirectInput(gii_di_priv *priv)
{
	if (NULL != priv->pKeyboard) {
		IDirectInputDevice_Unacquire(priv->pKeyboard);
		IDirectInputDevice_Release(priv->pKeyboard);
		priv->pKeyboard = NULL;
	}
	if (NULL != priv->pMouse) {
		IDirectInputDevice_Unacquire(priv->pMouse);
		IDirectInputDevice_Release(priv->pMouse);
		priv->pMouse = NULL;
	}
	if (NULL != priv->pDI) {
		IDirectInput2_Release(priv->pDI);
		priv->pDI = NULL;
	}

	return 0;
}


typedef struct DDMessageBoxStruct
{
	HWND hWnd;
	LPCTSTR text;
	LPCTSTR caption;
	UINT type;
} DDMBS, *LPDDMBS;


HRESULT
_gii_dx_DDMessageBox(HWND hWnd, LPCTSTR text, LPCTSTR caption)
{
	DDMBS MessageData;

	MessageData.hWnd = hWnd;
	MessageData.text = text;
	MessageData.caption = caption;
	MessageData.type = MB_OK;
	SendMessage(hWnd, WM_DDMESSAGEBOX, 0, (LPARAM) & MessageData);

	return 0;
}
