/* $Id: linkey.h,v 1.3 1998/11/21 23:55:52 marcus Exp $
******************************************************************************

   Convert Linux keysyms into LibGII syms and labels

   Copyright (C) 1998  Andrew Apted  [andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <linux/keyboard.h>
#include <ggi/internal/gii-dl.h>

uint32 _gii_linkey_labeltrans(int keysym, int shift);
uint32 _gii_linkey_symtrans(int keysym, int shift);

#ifdef WANT_TRANSLATE_SHIFT

#define SHIFT_MODS  ((1<<KG_SHIFT) | (1<<KG_SHIFTL) | (1<<KG_SHIFTR))
#define CTRL_MODS   ((1<<KG_CTRL)  | (1<<KG_CTRLL) | (1<<KG_CTRLR))
#define ALT_MODS    ((1<<KG_ALT)   | (1<<KG_ALTGR))

int _gii_linkey_shifttrans(int shift);

#endif
