/* $Id: init.c,v 1.3 1998/12/17 02:13:36 marcus Exp $
******************************************************************************

   LibGII initialization.

   Copyright (C) 1997 Jason McMullan	[jmcc@ggi-project.org]
   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

#include <ggi/internal/gii.h>

/* Global variables */
uint32                _giiDebugState = 0;
int                   _giiDebugSync = 0;
void                 *_giiconfhandle = NULL;

/* Static variables */
static int 	      _giiLibIsUp =0 ;
static char           giiconfstub[512] = GIICONFFILE;
static char          *giiconffile = giiconfstub + GIITAGLEN;

/*
 * Initalize the strutures for the library
 */

int giiInit(void)
{
	int err;
	const char *str;
	
	if (_giiLibIsUp>0) {
		/* Initialize only at first call. */
		_giiLibIsUp++;
		return 0;
	}

	err = ggInit();
	if (err != GGI_OK) {
		fprintf(stderr, "LibGII: unable to initialize LibGG\n");
		return err;
	}

	err = ggLoadConfig(giiconffile, &_giiconfhandle);
	if (err != GGI_OK) {
		ggExit();
		fprintf(stderr, "LibGII: fatal error - could not load %s\n",
			giiconffile);
		return err;
	}

	str = getenv("GGI_DEBUG");
	if (str != NULL) {
		_giiDebugState = atoi(str);
		DPRINT_CORE("Debugging=%d\n", _giiDebugState);
	}

	str = getenv("GGI_DEBUGSYNC");
	if (str != NULL) {
		_giiDebugSync = 1;
	}
		
	_giiLibIsUp++;
	return GGI_OK;
}

int giiExit(void)
{
	DPRINT_CORE("giiExit called\n");
	if (!_giiLibIsUp)
		return -1;

	if (_giiLibIsUp > 1) {
		_giiLibIsUp--;
		return _giiLibIsUp;
	}

	DPRINT_CORE("giiExit: really destroying.\n");
	/* Fixme close all inputs */
	
	ggFreeConfig(_giiconfhandle);
	ggExit();
	_giiLibIsUp=0;

	DPRINT_CORE("giiExit: done!\n");
	return 0;
}

