/* $Id: svgalib.h,v 1.1 1998/12/18 21:36:24 marcus Exp $
******************************************************************************

   LibGGI SVGAlib target

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]
   Copyright (C) 1998 Steve Cheng       [steve@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

   ----------------------------------------------------------------------
   README:

   Programs need SUID root. You really should use KGI :-)

   Uses raw keyboard mode! That means "a crash might render the console
   unusable. (but shouldn't)." Of course, SVGAlib is inherently dangerous,
   so this is nothing new.
   
   When using the SVGAlib target, LibGGI programs will always segfault at
   the end. This happens because SVGAlib likes to attach itself to the end
   of programs to do some 'cleanup'. The problem is, SVGAlib would be
   unloaded along with the target by ggiClose(), and hence it won't be there
   at the end of the program (cannot access memory). However, this behavior
   normally shouldn't cause any problems.

   This behaviour is avoided by doing a signal(SIGSEGV,_exit) in
   ggiClose(). This is only done if LIBGGI_DEBUG is != 0.
   To completely disable this, define ALWAYS_SEGFAULT_ON_EXIT below.
   
   Likewise, SVGAlib will also install its own signal handlers, so beware.
   
   See source for miscellaneous stuff. 
   The SVGAlib target now supports banked and modeX modes.

******************************************************************************
*/

#ifndef _GGI_DISPLAY_SVGALIB_H
#define _GGI_DISPLAY_SVGALIB_H

/*
 * ------------------------------------------------------------------------
 * Things you might want to change.
 * ------------------------------------------------------------------------
 */ 

/* Never prevent apps from segfaulting on exit */
/*
#define ALWAYS_SEGFAULT_ON_EXIT
*/

/*
 * ------------------------------------------------------------------------
 * Do not change anything below this line.
 * ------------------------------------------------------------------------
 */ 

#include <vga.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/modelist.h>

ggifunc_flush		GGI_svga_flush;
ggifunc_getmode		GGI_svga_getmode;
ggifunc_setmode		GGI_svga_setmode;
ggifunc_getapi		GGI_svga_getapi;
ggifunc_checkmode	GGI_svga_checkmode;
ggifunc_setflags	GGI_svga_setflags;

ggifunc_putpixel	GGI_svga_putpixel;
ggifunc_putpixel	GGI_svga_putpixel_nc;
ggifunc_getpixel	GGI_svga_getpixel;
ggifunc_drawpixel	GGI_svga_drawpixel;
ggifunc_drawpixel	GGI_svga_drawpixel_nc;
ggifunc_drawhline	GGI_svga_drawhline;
ggifunc_drawhline	GGI_svga_drawhline_nc;
ggifunc_drawvline	GGI_svga_drawvline;
ggifunc_drawvline	GGI_svga_drawvline_nc;
ggifunc_drawbox		GGI_svga_drawbox;
ggifunc_puthline	GGI_svga_puthline;
ggifunc_putbox		GGI_svga_putbox;

ggifunc_setpalvec	GGI_svga_setpalvec;

struct svga_priv {
	ggi_modelistmode *availmodes;
	uint8	         *memorigin;
	uint32		pixperframe;
	char		islinear;
	char		ismodex;
	char		isbanked;
};

#define SVGA_PRIV(vis) ((struct svga_priv*)LIBGGI_PRIVATE(vis))

#endif /* _GGI_DISPLAY_SVGALIB_H */
