/* $Id: aa.h,v 1.1 1998/12/18 21:36:24 marcus Exp $
******************************************************************************

   Headers for AA target.

   Copyright (C) 1997 Andreas Beck    [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_DISPLAY_AA_H
#define _GGI_DISPLAY_AA_H

#include <aalib.h>
#include <ggi/internal/ggi-dl.h>
#include <ggi/display/mansync.h>


ggifunc_flush		GGI_aa_flush;
ggifunc_getmode		GGI_aa_getmode;
ggifunc_setmode		GGI_aa_setmode;
ggifunc_checkmode	GGI_aa_checkmode;
ggifunc_getapi 		GGI_aa_getapi;
ggifunc_setflags	GGI_aa_setflags;

ggifunc_setpalvec	GGI_aa_setpalvec;

/* FIXME: Is this right? */
giifunc_eventpoll	GII_aa_poll;
/*
giifunc_sendevent	GII_aa_sendevent;
giifunc_seteventmask	GII_aa_seteventmask;
giifunc_geteventmask	GII_aa_geteventmask;
giifunc_getselectfdset	GII_aa_getselectfdset;
giifunc_close           GII_aa_close;
*/

#define AA_PRIV(vis) ((struct AAhooks *)LIBGGI_PRIVATE(vis))

#define MANSYNC_init(vis)   AA_PRIV(vis)->opmansync->init(vis)
#define MANSYNC_deinit(vis) AA_PRIV(vis)->opmansync->deinit(vis)
#define MANSYNC_start(vis)  AA_PRIV(vis)->opmansync->start(vis)
#define MANSYNC_stop(vis)   AA_PRIV(vis)->opmansync->stop(vis)
#define MANSYNC_ignore(vis) AA_PRIV(vis)->opmansync->ignore(vis)
#define MANSYNC_cont(vis)   AA_PRIV(vis)->opmansync->cont(vis)

struct AAhooks { 
	aa_context *context;
	aa_palette pal;
	void *aalock;
	_ggi_opmansync *opmansync;
	int lx, ly, lb;
	unsigned int lastkey, lastkeyticks;
};

void _GGI_aa_freedbs(ggi_visual *vis);

#endif /* _GGI_DISPLAY_AA_H */
