/* $Id: init.c,v 1.1 1998/12/09 04:27:28 marcus Exp $
******************************************************************************

   Misc extension initialization.

   Copyright (C) 1997 Uwe Maurer - uwe_maurer@t-online.de
   Copyright (C) 1998 Andreas Beck - becka@ggi-project.org
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <string.h>

#include "misc_int.h"

/*
 * The API of Extension #1 looks a bit like this :
 */

/* Extension ID. Defaulting to -1 should make segfault on abuse more likely ... */
ggi_extid ggiMiscID=-1;

static int changed(ggi_visual_t vis,int whatchanged)
{
	DPRINT("changed() called for misc extension - vis=%p, %i \n",
		vis,whatchanged);

	switch(whatchanged) {
		case GGI_CHG_APILIST:
			{	int temp;
				char api[256],args[256];
				void *err;
				DPRINT("changed() APILIST \n");
				for(temp=0;0==ggiGetAPI(vis,temp,api,args);temp++) {
					strcat(api,"-misc");
                	                DPRINT("Trying #%d: %s(%s)\n",temp,api,args);
					err=_ggiAddDL(vis, api, args, NULL, GGI_DLTYPE_EXTENSION);
                	                DPRINT("Loaded #%d: %s(%s) : %p\n",temp,api,args,err);
				}
			}
			break;
	}
                                
	return 0;
}

static int _ggi_error(void) { return -1; }

int ggiMiscInit(void)
{
	ggiMiscID=ggiExtensionRegister("GGIMisc",sizeof(miscext),changed);
	DPRINT("Initialized Misc extension. ID: %i\n",ggiMiscID);

	return ggiMiscID >= 0 ? 0 : -1;
}

int ggiMiscExit(void)
{
	int rc;
	rc=ggiExtensionUnregister(ggiMiscID);
	DPRINT("DeInitailized Misc extension. rc=%i\n", rc);

	return rc;
}

int ggiMiscAttach(ggi_visual_t vis)
{
	int rc;
	rc=ggiExtensionAttach(vis,ggiMiscID);
	DPRINT("Attached Misc extension to %p. rc=%i\n", vis, rc);

	if (rc==0) {	/* We are actually creating the primary instance. */
		memset(LIBGGI_MISCEXT(vis),0,sizeof(miscext));
		LIBGGI_MISCEXT(vis)->setsplitline
			=(int (*)(ggi_visual *vis,int y)) _ggi_error;
                LIBGGI_MISCEXT(vis)->getraypos=
		LIBGGI_MISCEXT(vis)->waitraypos
			=(int (*)(ggi_visual* vis,sint32 *x,sint32 *y))
			_ggi_error;
                        
		/* Now fake an "API change" so the right libs get loaded */
		changed(vis,GGI_CHG_APILIST);
	}

	return rc;
}

int ggiMiscDetach(ggi_visual_t vis)
{
	int rc;
	rc=ggiExtensionDetach(vis,ggiMiscID);
	DPRINT("Detached Misc extension from %p. rc=%i\n", vis, rc);

	return rc;
}

