/* $Id: visual.c,v 1.24 1998/12/18 21:36:23 marcus Exp $
******************************************************************************

   Display-multi: initialization

   Copyright (C) 1995 Andreas Beck    [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan  [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <ggi/internal/ggi-dl.h>

#include <ggi/display/multi.h>

/*
 * We are guaranteed to have been checked already...
 */

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	MultiHook *mm;
	char target[1024];

	if (! args) {
		fprintf(stderr, "display-multi: missing target names.\n");
		return GGI_DL_ERROR;
	}

	LIBGGI_PRIVATE(vis) = mm = _ggi_malloc(sizeof(MultiHook));

	mm->vis_num  = 0;
	mm->vis_list = NULL;

	for (;;) {
		MultiVis *cur;

		args = ggParseTarget((char *) args, target, 1024);

		if (args == NULL) {
			/* error occurred */
			free(mm);
			return GGI_DL_ERROR;
		}

		if (*target == 0) {
			strcpy(target, "auto");
		}
		
		cur = _ggi_malloc(sizeof(MultiVis));

		DPRINT("display-multi: opening sub #%d: %s\n",
			mm->vis_num+1, target);

		cur->vis = ggiOpen(target, NULL);

		if (cur->vis == NULL) {
			fprintf(stderr, "display-multi: failed trying "
				"to open: %s\n", target);
			free(cur); free(mm);
			return GGI_DL_ERROR;
		}

		/* add to head */

		cur->next = mm->vis_list;
		mm->vis_list = cur;
		mm->vis_num++;

		/* Add giiInputs, if we have them. */
		if (cur->vis->input) {
			vis->input = giiJoinInputs(vis->input,cur->vis->input);
			cur->vis->input = NULL;	/* Destroy old reference */
		}

		while (*args && isspace((int)*args)) args++;

		if (*args == 0) {
			break;
		}

		if (*args != ':') {
			fprintf(stderr, "display-multi: expecting ':' "
				"between targets.\n");
			free(mm);
			return GGI_DL_ERROR;
		}

		args++;  /* skip ':' */
	}

	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	/* Has mode management */
	vis->opdisplay->getmode=GGI_multi_getmode;
	vis->opdisplay->setmode=GGI_multi_setmode;
	vis->opdisplay->checkmode=GGI_multi_checkmode;
	vis->opdisplay->flush=GGI_multi_flush;
	vis->opdisplay->setflags=GGI_multi_setflags;

	vis->opgc->gcchanged=GGI_multi_gcchanged;

	vis->opdraw->fillscreen=GGI_multi_fillscreen;
	vis->opdraw->setorigin=GGI_multi_setorigin;

	vis->opdraw->putc=GGI_multi_putc;
	vis->opdraw->puts=GGI_multi_puts;
	vis->opdraw->getcharsize=GGI_multi_getcharsize;

	vis->opdraw->drawpixel_nc=GGI_multi_drawpixel;
	vis->opdraw->drawpixel=GGI_multi_drawpixel;
	vis->opdraw->putpixel_nc=GGI_multi_putpixel;
	vis->opdraw->putpixel=GGI_multi_putpixel;
	vis->opdraw->getpixel=GGI_multi_getpixel;

	vis->opdraw->drawline=GGI_multi_drawline;
	vis->opdraw->drawhline=GGI_multi_drawhline;
	vis->opdraw->puthline=GGI_multi_puthline;
	vis->opdraw->gethline=GGI_multi_gethline;

	vis->opdraw->drawvline=GGI_multi_drawvline;
	vis->opdraw->putvline=GGI_multi_putvline;
	vis->opdraw->getvline=GGI_multi_getvline;

	vis->opdraw->drawbox=GGI_multi_drawbox;
	vis->opdraw->putbox=GGI_multi_putbox;
	vis->opdraw->getbox=GGI_multi_getbox;
	vis->opdraw->copybox=GGI_multi_copybox;

	vis->opcolor->getgamma=GGI_multi_getgamma;
	vis->opcolor->setgamma=GGI_multi_setgamma;
	vis->opcolor->getgammamap=GGI_multi_getgammamap;
	vis->opcolor->setgammamap=GGI_multi_setgammamap;

	vis->opcolor->mapcolor=GGI_multi_mapcolor;
	vis->opcolor->unmappixel=GGI_multi_unmappixel;
	vis->opcolor->setpalvec=GGI_multi_setpalvec;
	vis->opcolor->getpalvec=GGI_multi_getpalvec;

	return GGI_DL_OPDISPLAY | GGI_DL_OPCOLOR |
	       GGI_DL_OPDRAW | GGI_DL_OPGC;
}

int GGIdlcleanup(ggi_visual *vis)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	while (mm->vis_list != NULL) {

		/* remove head */

		cur = mm->vis_list;
		mm->vis_list = cur->next;
		mm->vis_num--;

		ggiClose(cur->vis);
		free(cur);
	}

	free(mm);
	free(LIBGGI_GC(vis));

	return 0;
}

#include <ggi/internal/ggidlinit.h>
