/* $Id: visual.c,v 1.25 1998/12/18 21:36:23 marcus Exp $
******************************************************************************

   Display-monotext: visual management

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <ggi/display/monotext.h>

#define TERMINATOR(c)  (((c) == 0) || isspace((int)c) || ((c) == ':'))
	
#define SKIP_ARG  \
	do { while (isspace((int)*args)) args++; if (*args == ':') args++;  \
	} while (0)
	
static char *parse_arguments(MonotextHook *mt, char *args)
{
	for (;;) {
		while (isspace((int)*args)) args++;

		if (args[0] != '-') {
			break;
		}
		
		if ((strncmp(args, "-a", 2) == 0) && isdigit((int)args[2]) &&
		    TERMINATOR(args[3])) {
		    
			switch (args[2]) {

				case '1': mt->accuracy.x = 1;
				          mt->accuracy.y = 1; break;
			
				case '2': mt->accuracy.x = 1;
				          mt->accuracy.y = 2; break;
			
				case '3': mt->accuracy.x = 2;
				          mt->accuracy.y = 2; break;
			
				case '4': mt->accuracy.x = 2;
				          mt->accuracy.y = 4; break;
			
				case '5': mt->accuracy.x = 4;
				          mt->accuracy.y = 4; break;

				default:
					fprintf(stderr, "display-monotext: "
						"Unknown accuracy '%c'.\n",
						args[2]);
					return NULL;
			}

			args += 3; SKIP_ARG;
			continue;
		}
	
		fprintf(stderr, "display-monotext: Unknown argument -%c "
			"or syntax error.\n", args[1]);
	}

	return args;
}


int GGIdlinit(ggi_visual *vis, const char *args,void *argptr)
{
	MonotextHook *mt;

	char target[1024];


	DPRINT("display-monotext: GGIdlinit start.\n");

	LIBGGI_FD(vis) = -1;

	if ((args == NULL) || (*args == 0)) {
		fprintf(stderr, "display-monotext: needs the real target "
			"as argument.\n");
		return -1;
	}

	mt = LIBGGI_PRIVATE(vis) = _ggi_malloc(sizeof(MonotextHook));

	vis->gc = _ggi_malloc(sizeof(ggi_gc));


	/* set defaults */

	mt->parent_gt = GT_TEXT16;
	mt->flags = 0;
	mt->accuracy.x = 2; mt->accuracy.y = 4;
	mt->squish.x = mt->squish.y = 1;
	

	/* handle arguments */

	args = parse_arguments(mt, (char *) args);

	if (args == NULL) {
		free(mt);
		return GGI_DL_ERROR;
	}


	/* open the parent visual */

	DPRINT("display-monotext: opening target: %s\n", args);

	if (ggParseTarget((char *) args, target, 1024) == NULL) {
		/* error occurred */
		free(mt);
		return GGI_DL_ERROR;
	}

	if (*target == 0) {
		strcpy(target, "auto");
	}

	mt->parent = ggiOpen(target, NULL);

	if (mt->parent == NULL) {
		fprintf(stderr, "display-monotext: Failed to open "
			"target: %s\n", target);
		free(mt);
		return GGI_DL_ERROR;
	}
	
	ggiSetFlags(mt->parent, GGIFLAG_ASYNC);

	/* add giiInputs, if we have them */

	if (mt->parent->input) {
		vis->input=giiJoinInputs(vis->input, mt->parent->input);
		mt->parent->input=NULL; /* destroy old reference */
	}

	vis->opdisplay->getmode = GGI_monotext_getmode;
	vis->opdisplay->setmode = GGI_monotext_setmode;
	vis->opdisplay->checkmode = GGI_monotext_checkmode;
	vis->opdisplay->getapi = GGI_monotext_getapi;
	vis->opdisplay->flush = GGI_monotext_flush;
	vis->opdisplay->setflags = GGI_monotext_setflags;
	
	DPRINT("display-monotext: GGIdlinit succeeded.\n");

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);

	DPRINT("display-monotext: GGIdlcleanup start.\n");

	if (mt->fb_ptr != NULL) {
		_ggi_monotextClose(vis);
		free(mt->fb_ptr);
		mt->fb_ptr = NULL;
	}

	if (mt->parent != NULL) {
		ggiClose(mt->parent);
		mt->parent = NULL;

		giiClose(vis->input);
		vis->input = NULL;
	}

	free(mt);
	LIBGGI_PRIVATE(vis) = NULL;

	DPRINT("display-monotext: GGIdlcleanup done.\n");

	return 0;
}

#include <ggi/internal/ggidlinit.h>
