/* $Id: visual.c,v 1.24 1998/12/18 21:36:22 marcus Exp $
******************************************************************************

   GLIDE target - Initialization

   Copyright (C) 1997-1998	Jon Taylor	[taylorj@ecs.csus.edu]
   Copyright (C) 1998		Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ggi/display/glide.h>

int GGIdlinit(ggi_visual *vis, const char *args,void *argptr)
{
	struct glide_hooks *priv;
	const char *inputname;
	gii_input *inp;
	
	DPRINT("GLIDE-lib starting\n");

	if ((priv = malloc(sizeof(struct glide_hooks))) == NULL) {
		return GGI_DL_ERROR;
	}
	if ((LIBGGI_GC(vis) = malloc(sizeof(ggi_gc))) == NULL) {
		free(priv);
		return GGI_DL_ERROR;
	}
	
	if (args != NULL) {
		inputname = args;
	} else {
		if (getenv("DISPLAY") != NULL) {
			inputname = "x";
		} else {
			inputname = "linux-kbd";
		}
	}
	if (strstr(inputname, "linux-kbd") != NULL) {
		priv->on_linux_cons = 1;
	} else {
		priv->on_linux_cons = 0;
	}

	/* Open keyboard and mouse input */
	vis->input = giiOpen(inputname, NULL);
	if (vis->input == NULL) {
		fprintf(stderr, "display-glide: Couldn't open input.\n");
		free(LIBGGI_GC(vis));
		free(priv);
		return GGI_DL_ERROR;
	}
	if (priv->on_linux_cons) {
		if ((inp = giiOpen("linux-mouse:file", &args, NULL)) != NULL) {
			vis->input = giiJoinInputs(vis->input, inp);
		}
	}

	/* Prevent 3DFX splash-screen from being displayed */
	if (getenv("FX_GLIDE_NO_SPLASH") == NULL)
		setenv("FX_GLIDE_NO_SPLASH", "1", 0);

	grGlideInit();
	grSstSelect(0);
	
	priv->setmodesuccess = 0;
	LIBGGI_PRIVATE(vis) = priv;

	/* Has mode management */
	vis->opdisplay->flush = GGI_glide_flush;
	vis->opdisplay->getmode = GGI_glide_getmode;
	vis->opdisplay->setmode = GGI_glide_setmode;
	vis->opdisplay->checkmode = GGI_glide_checkmode;
	vis->opdisplay->getapi = GGI_glide_getapi;
	vis->opdisplay->flush = GGI_glide_flush;	

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	struct glide_hooks *priv = LIBGGI_PRIVATE(vis);

	if (priv->on_linux_cons && priv->setmodesuccess) {
		vtswitch_close(vis);
	}

	giiClose(vis->input);
	vis->input = NULL;

	free(priv);
	free(LIBGGI_GC(vis));
	
	grGlideShutdown();

	return 0;
}

#include <ggi/internal/ggidlinit.h>
