/* $Id: giievents.c,v 1.5 1998/12/22 02:12:03 marcus Exp $
******************************************************************************

   Graphics library for GGI.  Events for AA target.

   Copyright (C) 1998 Steve Cheng     [steve@ggi-project.org]
   Copyright (C) 1997 Andreas Beck    [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>
#include <string.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/aa.h>


static void add_key_event(gii_input_t inp, int key, ggi_event_mask type)
{
	ggi_event ggievent;

	_giiEventBlank(&ggievent);

	if(type==evKeyRelease)
		key &= ~AA_RELEASE;
	
	switch(key)
	{
		case AA_UP: 		key = GIIK_Up;
		case AA_DOWN:		key = GIIK_Down;
		case AA_LEFT:		key = GIIK_Left;
		case AA_RIGHT:		key = GIIK_Right;
		case AA_BACKSPACE:	key = GIIUC_BackSpace;
		case AA_ESC:		key = GIIUC_Escape;
		/*default:		key = LATIN_KEY(key);*/
	}

	ggievent.any.size = sizeof(ggi_key_event);
	ggievent.any.type = type;

	ggievent.key.sym
		= ggievent.key.label
		= ggievent.key.button = key;
	
	_giiEvQueueAdd(inp, &ggievent);
}



/************************** GGI Functions ***************************/
/* Event Handling */
ggi_event_mask GII_aa_poll(gii_input_t inp)
{

	struct AAhooks *aahook=inp->priv;
	ggi_event_mask evmask = 0;
	int lastkey = 0;
	int n;

	DPRINT_EVENTS("GII_aa_poll\n");

	if(!aahook->context) 
		return 0;

	do {
		n = aa_getevent(aahook->context, 0);

		DPRINT_EVENTS("AA: got event %x\n",n);


		if(n==AA_MOUSE)
		{
			ggi_event ggievent;
			int x, y, b;

			aa_getmouse(aahook->context, &x, &y, &b);

			evmask |= emPtrAbsolute;

			_giiEventBlank(&ggievent);
			ggievent.any.size = sizeof(ggi_pmove_event);
			ggievent.any.type = evPtrAbsolute;

			/* Mouse movement is in screen coordinates;
			   we assume one screen pixel : four image pixels */
			ggievent.pmove.x = x*2;
			ggievent.pmove.y = y*2;

			_giiEvQueueAdd(inp, &ggievent);

#if 0
			/* Now check the buttons */
			if (b!=lb)
			{
				_giiEventBlank(&ggievent);
				ggievent.any.size = sizeof(ggi_pbutton_event);

				if ( (b^lb) & b )
					ggievent.any.type = evPtrButtonPress;
				else 
					ggievent.any.type = evPtrButtonRelease;

				ggievent.pbutton.state=b;
				ggievent.pbutton.button=b^lb;

				aahook->lb = lb = b;
					
				_ggiEvQueueAdd(inp, &ggievent);
			}
#endif
		}
		
		/* No more events.  If lastkey != 0, we release that key. */
		else if(n==AA_NONE && lastkey)
		{
			evmask |= emKeyRelease;
			add_key_event(inp, lastkey, evKeyRelease);
			lastkey = 0;
		}
		
		else if(n==AA_RESIZE || n==AA_UNKNOWN) {
		}

		else if (n>=1 && n<=AA_RELEASE)
		{
			/* First hit */
			if(lastkey == 0) {
				evmask |= emKeyPress;
				add_key_event(inp, n, evKeyPress);
			}

			/* Repeated keypress */
			else if(lastkey == n) {
				evmask |= emKeyRepeat;
				add_key_event(inp, n, evKeyRepeat);
			}

			/* whoops!  different key!  We send a release for
			   the lastkey first. */
			else {
				evmask |= emKeyRelease | emKeyPress;
				add_key_event(inp, lastkey, evKeyRelease);
				add_key_event(inp, n, evKeyPress);
			}

			lastkey = n;
		} 

		else if (n>AA_RELEASE)
		{
			/* Release given key.  It should match lastkey,
			   but if it doesn't, tough luck, we clear it anyway. */

			evmask |= emKeyRelease;
			add_key_event(inp, n, evKeyRelease);
			lastkey = 0;
		} 

	} while (n!=AA_NONE);

	return evmask;
}
