/* $Id: visual.c,v 1.25 1998/12/18 21:36:22 marcus Exp $
******************************************************************************

   Display-Xlib initialization.

   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/xlib.h>

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	struct Xhooks *xinfo;

	DPRINT("X-lib starting.\n");

	xinfo = _ggi_malloc(sizeof(struct Xhooks));

	if ((xinfo->XLibLock = ggLockCreate()) == NULL) {
		free(xinfo);
		return GGI_DL_ERROR;
	}

	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	xinfo->display=NULL;
	xinfo->cmap=0;
	xinfo->cmap_first=256;
	xinfo->cmap_last=0;
	xinfo->window=0;
	xinfo->gc=0;
	xinfo->tempgc=0;
	xinfo->viswidth=0;
	xinfo->visheight=0;

	DPRINT("X-lib wants display %s.\n",args);
	xinfo->display = XOpenDisplay(args);
	if (xinfo->display == NULL)
		return GGI_DL_ERROR;

	DPRINT("X-lib has display %s.\n",args);

	xinfo->screen = DefaultScreen (xinfo->display);
	DPRINT("X-lib has screen.\n");
	DPRINT("X-lib fully up.\n");

	/* Has mode management */
	vis->opdisplay->flush=GGI_Xlib_flush;
	vis->opdisplay->getmode=GGI_Xlib_getmode;
	vis->opdisplay->setmode=GGI_Xlib_setmode;
	vis->opdisplay->checkmode=GGI_Xlib_checkmode;
	vis->opdisplay->getapi =GGI_Xlib_getapi;
	vis->opdisplay->setflags=GGI_Xlib_setflags;

	{
		gii_inputxwin_arg args;
		gii_input *inp;
		
		args.disp = xinfo->display;
		args.ptralwaysrel = 0;
		args.wait = 1;
		
		if ((inp = giiOpen("xwin", &args, NULL)) == NULL) {
			DPRINT_MISC("Unable to open xwin inputlib\n");
			GGIdlcleanup(vis);
			return GGI_DL_ERROR;
		}

		xinfo->inp = inp;
		/* Now join the new event source in. */
		vis->input = giiJoinInputs(vis->input, inp);
        }

	LIBGGI_PRIVATE(vis) = xinfo;

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	struct Xhooks *xinfo;

	if ((xinfo=LIBGGI_PRIVATE(vis)) != NULL) {
		if (xinfo->cmap)
			XFreeColormap(xinfo->display,xinfo->cmap);
		if (xinfo->gc) {
			XFreeGC(xinfo->display,xinfo->gc);
			XFreeGC(xinfo->display,xinfo->tempgc);
		}
		if (xinfo->window) 
			XDestroyWindow(xinfo->display,xinfo->window);
		XSync(xinfo->display,0);
		if (xinfo->display)
		{
			XCloseDisplay(xinfo->display);
		}

		ggLockDestroy(xinfo->XLibLock);

		free(LIBGGI_PRIVATE(vis));
	}

	if(vis->palette)
		free(vis->palette);
	free(LIBGGI_GC(vis));

	return 0;
}

#include <ggi/internal/ggidlinit.h>
